/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.testing.benchmark;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingProbe<T>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TestingProbe.class);
    private static final long ERRONEOUS_METRIC_VALUE = -1L;
    public final String namespace;
    public final String elementCounterName;
    public final String processingTimeDistributionName;
    private final MonitorDoFn doFn;
    private final PTransform<PCollection<? extends T>, PCollection<T>> transform;

    public TestingProbe(String namespace, String prefix) {
        this.namespace = namespace;
        this.elementCounterName = prefix + ".elements";
        this.processingTimeDistributionName = prefix + ".processingTime";
        this.doFn = new MonitorDoFn();
        this.transform = ParDo.of((DoFn)this.doFn);
    }

    public PTransform<PCollection<? extends T>, PCollection<T>> getTransform() {
        return this.transform;
    }

    public long getElementCount(PipelineResult result) {
        return TestingProbe.getElementCount(this.namespace, this.elementCounterName, result);
    }

    public long getStartProcessingTime(PipelineResult result) {
        Iterable<MetricResult<DistributionResult>> timeDistributions = this.getDistributions(result);
        return this.getLowestMin(timeDistributions);
    }

    private Long getLowestMin(Iterable<MetricResult<DistributionResult>> distributions) {
        Optional<Long> lowestMin = StreamSupport.stream(distributions.spliterator(), true).map(element -> ((DistributionResult)element.getAttempted()).getMin()).filter(TestingProbe::isCredible).min(Long::compareTo);
        return lowestMin.orElse(-1L);
    }

    public long getEndProcessingTime(PipelineResult result) {
        Iterable<MetricResult<DistributionResult>> timeDistributions = this.getDistributions(result);
        return this.getGreatestMax(timeDistributions);
    }

    private Long getGreatestMax(Iterable<MetricResult<DistributionResult>> distributions) {
        Optional<Long> greatestMax = StreamSupport.stream(distributions.spliterator(), true).map(element -> ((DistributionResult)element.getAttempted()).getMax()).filter(TestingProbe::isCredible).max(Long::compareTo);
        return greatestMax.orElse(-1L);
    }

    private Iterable<MetricResult<DistributionResult>> getDistributions(PipelineResult result) {
        MetricQueryResults metrics = result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named((String)this.namespace, (String)this.processingTimeDistributionName)).build());
        return metrics.getDistributions();
    }

    public Snapshot takeSnapshot(PipelineResult result) {
        return new Snapshot(this.getElementCount(result), this.getStartProcessingTime(result), this.getEndProcessingTime(result));
    }

    private static boolean isCredible(long value) {
        return Math.abs(value - System.currentTimeMillis()) <= Duration.standardDays((long)10000L).getMillis();
    }

    public static long getElementCount(String namespace, String metricName, PipelineResult result) {
        MetricQueryResults metrics = result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named((String)namespace, (String)metricName)).build());
        Iterable counters = metrics.getCounters();
        TestingProbe.checkIfMetricResultIsUnique(metricName, namespace, counters);
        try {
            MetricResult metricResult = (MetricResult)counters.iterator().next();
            return (Long)metricResult.getAttempted();
        }
        catch (NoSuchElementException e) {
            LOG.error("Failed to get metric {}, from namespace {}", (Object)metricName, (Object)namespace);
            return -1L;
        }
    }

    private static <T> void checkIfMetricResultIsUnique(String metricName, String namespace, Iterable<MetricResult<T>> metricResult) throws IllegalStateException {
        int resultCount = Iterables.size(metricResult);
        Preconditions.checkState((resultCount <= 1 ? 1 : 0) != 0, (String)"More than one metric result matches name: %s in namespace %s. Metric results count: %s", (Object)metricName, (Object)namespace, (Object)resultCount);
    }

    public static class Snapshot {
        public final long count;
        public final long start;
        public final long end;

        public Snapshot(long count, long start, long end) {
            this.count = count;
            this.start = start;
            this.end = end;
        }

        public double rate() {
            long ms = this.end - this.start;
            return ms == 0L ? 0.0 : (double)this.count / (double)ms * 1000.0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return this.count == snapshot.count && this.start == snapshot.start && this.end == snapshot.end;
        }

        public int hashCode() {
            return Objects.hash(this.count, this.start, this.end);
        }
    }

    private class MonitorDoFn
    extends DoFn<T, T> {
        final Counter elementCounter;
        final Distribution processingTime;

        private MonitorDoFn() {
            this.elementCounter = Metrics.counter((String)TestingProbe.this.namespace, (String)TestingProbe.this.elementCounterName);
            this.processingTime = Metrics.distribution((String)TestingProbe.this.namespace, (String)TestingProbe.this.processingTimeDistributionName);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            this.elementCounter.inc();
            this.processingTime.update(System.currentTimeMillis());
            c.output(c.element());
        }
    }
}

