/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.testing.flowgen;

import java.util.function.Supplier;

public abstract class Limiter {
    public static Limiter OFF = new Limiter(){

        @Override
        public boolean check(long incr) {
            return true;
        }

        @Override
        public long state() {
            return 0L;
        }
    };

    public abstract boolean check(long var1);

    public abstract long state();

    public static Limiter of(long flowsPerSecond) {
        return Limiter.of(flowsPerSecond, System::currentTimeMillis);
    }

    public static Limiter restore(long flowsPerSecond, long limiterState) {
        return Limiter.restore(flowsPerSecond, limiterState, System::currentTimeMillis);
    }

    public static Limiter of(long flowsPerSecond, Supplier<Long> currentTimeMillis) {
        if (flowsPerSecond <= 0L) {
            return OFF;
        }
        return new FlowsPerSecond(currentTimeMillis, flowsPerSecond);
    }

    public static Limiter restore(long flowsPerSecond, long limiterState, Supplier<Long> currentTimeMillis) {
        if (flowsPerSecond <= 0L) {
            return OFF;
        }
        return new FlowsPerSecond(currentTimeMillis, flowsPerSecond, limiterState);
    }

    public static class FlowsPerSecond
    extends Limiter {
        private final Supplier<Long> currentTimeMillis;
        private final long flowsPerSecond;
        private long allowance;
        private long lastCheck;

        public FlowsPerSecond(Supplier<Long> currentTimeMillis, long flowsPerSecond) {
            this.currentTimeMillis = currentTimeMillis;
            this.flowsPerSecond = flowsPerSecond;
            this.allowance = flowsPerSecond * 1000L;
            this.lastCheck = currentTimeMillis.get();
        }

        public FlowsPerSecond(Supplier<Long> currentTimeMillis, long flowsPerSecond, long state) {
            this.currentTimeMillis = currentTimeMillis;
            this.flowsPerSecond = flowsPerSecond;
            this.allowance = state % flowsPerSecond;
            this.lastCheck = state / flowsPerSecond;
        }

        @Override
        public boolean check(long incr) {
            long current = this.currentTimeMillis.get();
            long timePassed = current - this.lastCheck;
            this.lastCheck = current;
            this.allowance += timePassed * this.flowsPerSecond;
            if (this.allowance > this.flowsPerSecond * 1000L) {
                this.allowance = this.flowsPerSecond * 1000L;
            }
            if (this.allowance >= incr * 1000L) {
                this.allowance -= incr * 1000L;
                return true;
            }
            return false;
        }

        @Override
        public long state() {
            long l = this.lastCheck - this.allowance / this.flowsPerSecond;
            long a = this.allowance % this.flowsPerSecond;
            return l * this.flowsPerSecond + a;
        }
    }
}

