/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.testing.flowgen;

import java.io.Serializable;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.opennms.nephron.testing.flowgen.FlowDocuments;
import org.opennms.nephron.testing.flowgen.FlowGenOptions;

public class FlowConfig
implements Serializable {
    public static SerializableBiFunction<Long, FlowDocuments.FlowData, Instant> CURRENT_TIME_LAST_SWITCHED_POLICY = (SerializableBiFunction & Serializable)(idx, fd) -> Instant.now();
    public final int minExporter;
    public final int numExporters;
    public final int minInterface;
    public final int numInterfaces;
    public final int numProtocols;
    public final int numApplications;
    public final int numHosts;
    public final int numEcns;
    public final int numDscps;
    public final SerializableBiFunction<Long, FlowDocuments.FlowData, Instant> lastSwitched;
    public final SerializableFunction<Integer, Duration> clockSkew;
    public final Duration lastSwitchedSigma;
    public final double flowDurationLambda;

    public static SerializableBiFunction<Long, FlowDocuments.FlowData, Instant> linearIncreasingLastSwitchedPolicy(Instant start, Duration step) {
        return (SerializableBiFunction & Serializable)(idx, fd) -> start.plus((ReadableDuration)step.multipliedBy(idx.longValue()));
    }

    public static SerializableBiFunction<Long, FlowDocuments.FlowData, Instant> uniformInWindowLastSwitchedPolicy(FlowGenOptions opts) {
        Instant start = Instant.ofEpochMilli((long)opts.getStartMs());
        Duration step = Duration.millis((long)((long)((double)opts.getFixedWindowSizeMs() / (double)opts.getFlowsPerWindow().longValue())));
        return FlowConfig.linearIncreasingLastSwitchedPolicy(start, step);
    }

    public static SerializableFunction<Integer, Duration> groupClockSkewPolicy(FlowGenOptions options) {
        long clockSkewShiftMs;
        long clockSkewMs;
        int numClockSkewGroups = options.getNumClockSkewGroups();
        if (numClockSkewGroups == 1) {
            return (SerializableFunction & Serializable)nodeId -> Duration.ZERO;
        }
        int minExporter = options.getMinExporter();
        switch (options.getClockSkewDirection()) {
            case AHEAD: {
                clockSkewMs = Math.abs(options.getClockSkewMs());
                clockSkewShiftMs = 0L;
                break;
            }
            case BEHIND: {
                clockSkewMs = -Math.abs(options.getClockSkewMs());
                clockSkewShiftMs = 0L;
                break;
            }
            default: {
                clockSkewMs = Math.abs(options.getClockSkewMs());
                clockSkewShiftMs = clockSkewMs * (long)(options.getNumClockSkewGroups() - 1) / 2L;
            }
        }
        return (SerializableFunction & Serializable)nodeId -> Duration.millis((long)((long)((nodeId - minExporter) % numClockSkewGroups) * clockSkewMs - clockSkewShiftMs));
    }

    public FlowConfig(int minExporter, int numExporters, int minInterface, int numInterfaces, int numProtocols, int numApplications, int numHosts, int numEcns, int numDscps, SerializableBiFunction<Long, FlowDocuments.FlowData, Instant> lastSwitched, SerializableFunction<Integer, Duration> clockSkew, Duration lastSwitchedSigma, double flowDurationLambda) {
        this.minExporter = minExporter;
        this.numExporters = numExporters;
        this.minInterface = minInterface;
        this.numInterfaces = numInterfaces;
        this.numProtocols = numProtocols;
        this.numApplications = numApplications;
        this.numHosts = numHosts;
        this.numEcns = numEcns;
        this.numDscps = numDscps;
        this.lastSwitched = lastSwitched;
        this.clockSkew = clockSkew;
        this.lastSwitchedSigma = lastSwitchedSigma;
        this.flowDurationLambda = flowDurationLambda;
    }

    public FlowConfig(FlowGenOptions opts, SerializableBiFunction<Long, FlowDocuments.FlowData, Instant> lastSwitched, SerializableFunction<Integer, Duration> clockSkew) {
        this(opts.getMinExporter(), opts.getNumExporters(), opts.getMinInterface(), opts.getNumInterfaces(), opts.getNumProtocols(), opts.getNumApplications(), opts.getNumHosts(), opts.getNumEcns(), opts.getNumDscps(), lastSwitched, clockSkew, Duration.millis((long)opts.getLastSwitchedSigmaMs()), opts.getFlowDurationLambda());
    }
}

