/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.testing.flowgen;

import com.codepoetics.protonpack.StreamUtils;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import java.util.Iterator;
import java.util.Random;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.Shrinkable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.opennms.nephron.testing.flowgen.FlowConfig;
import org.opennms.nephron.testing.flowgen.SourceConfig;
import org.opennms.netmgt.flows.persistence.model.Direction;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;
import org.opennms.netmgt.flows.persistence.model.NodeInfo;

public class FlowDocuments {
    private static Arbitrary<Double> UNIFORM = Arbitraries.doubles().between(0.001, true, 1.0, true).ofScale(3);
    private static Arbitrary<Double> NORMAL = Combinators.combine(UNIFORM, UNIFORM).as((d1, d2) -> Math.sqrt(-2.0 * Math.log(d1)) * Math.cos(Math.PI * 2 * d2));
    private static Arbitrary<Double> EXPONENTIAL = UNIFORM.map(d -> -Math.log(d));
    private static Arbitrary<Long> BYTES = Arbitraries.longs().between(0L, 0x100000L);

    public static Stream<FlowDocument> stream(SourceConfig sourceConfig) {
        return FlowDocuments.stream(sourceConfig.flowConfig, sourceConfig.seed, sourceConfig.maxIdx, sourceConfig.idxInc, sourceConfig.idxOffset);
    }

    public static Stream<FlowDocument> splittedStream(SourceConfig sourceConfig) {
        if (sourceConfig.minSplits != sourceConfig.maxSplits) {
            throw new RuntimeException("minimum and maximum number of splits must be equals - minSplits: " + sourceConfig.minSplits + "; maxSplits: " + sourceConfig.maxSplits);
        }
        final Iterator[] iters = (Iterator[])sourceConfig.split(sourceConfig.minSplits).stream().map(FlowDocuments::stream).map(s -> s.iterator()).toArray(Iterator[]::new);
        Iterator<FlowDocument> iter = new Iterator<FlowDocument>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                int cnt = iters.length;
                while (cnt-- > 0) {
                    if (iters[this.idx].hasNext()) {
                        return true;
                    }
                    this.idx = (this.idx + 1) % iters.length;
                }
                return false;
            }

            @Override
            public FlowDocument next() {
                return (FlowDocument)iters[this.idx].next();
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 16), false);
    }

    public static Stream<FlowDocument> stream(FlowConfig cfg, long seed, long maxIdx, int idxInc, int idxOffset) {
        Arbitrary<FlowData> flowData = FlowDocuments.getFlowDataArbitrary(cfg);
        return StreamUtils.zipWithIndex((Stream)flowData.generator(1000).stream(new Random(seed))).limit(maxIdx / (long)idxInc).map(zipped -> {
            long idx = zipped.getIndex() * (long)idxInc + (long)idxOffset;
            FlowData fd = (FlowData)((Shrinkable)zipped.getValue()).value();
            FlowDocument f = FlowDocuments.getFlowDocument(cfg, idx, fd);
            return f;
        });
    }

    public static FlowDocument getFlowDocument(FlowConfig cfg, long idx, FlowData fd) {
        String dstAddress;
        Instant lastSwitchedWithoutClockSkew = ((Instant)cfg.lastSwitched.apply((Object)idx, (Object)fd)).plus((ReadableDuration)fd.fd2.lastSwitchedOffset);
        Duration clockSkew = (Duration)cfg.clockSkew.apply((Object)fd.fd1.nodeId);
        Instant lastSwitched = lastSwitchedWithoutClockSkew.plus((ReadableDuration)clockSkew);
        Instant deltaSwitched = lastSwitched.minus((ReadableDuration)fd.fd2.flowDuration);
        String srcAddress = FlowDocuments.ipAddress(fd.fd1.srcAddr);
        if (srcAddress.compareTo(dstAddress = FlowDocuments.ipAddress(fd.fd1.dstAddr)) < 0) {
            String minAddr = srcAddress;
            String maxAddr = dstAddress;
        } else {
            String maxAddr = srcAddress;
            String minAddr = dstAddress;
        }
        String application = "app" + fd.fd1.application;
        double numBytesScaleFactor = 0.5 * Math.exp(-0.5 * (double)(fd.fd1.application + fd.fd1.srcAddr + fd.fd1.dstAddr));
        FlowDocument f = FlowDocument.newBuilder().setExporterNode(NodeInfo.newBuilder().setNodeId(fd.fd1.nodeId).setForeginId("fId" + fd.fd1.nodeId).setForeignSource("fSource" + fd.fd1.nodeId).build()).setLocation("Default").setProtocol(UInt32Value.of((int)fd.fd1.protocol)).setInputSnmpIfindex(UInt32Value.of((int)fd.fd1.inputInterfaceIdx)).setOutputSnmpIfindex(UInt32Value.of((int)fd.fd1.outputInterfaceIdx)).setApplication(application).setSrcAddress(srcAddress).setSrcHostname("host" + fd.fd1.srcAddr).setDstAddress(dstAddress).setDstHostname("host" + fd.fd1.dstAddr).setDirection(fd.fd2.ingressNotEgress ? Direction.INGRESS : Direction.EGRESS).setLastSwitched(UInt64Value.of((long)lastSwitched.getMillis())).setDeltaSwitched(UInt64Value.of((long)deltaSwitched.getMillis())).setNumBytes(UInt64Value.of((long)((long)((double)fd.fd2.bytes * numBytesScaleFactor)))).setTos(UInt32Value.of((int)(fd.fd2.ecn + 4 * fd.fd2.dscp))).setEcn(UInt32Value.of((int)fd.fd2.ecn)).setDscp(UInt32Value.of((int)fd.fd2.dscp)).build();
        return f;
    }

    public static String ipAddress(int ip) {
        return String.format("%d.%d.%d.%d", ip >> 24 & 0xFF, ip >> 16 & 0xFF, ip >> 8 & 0xFF, ip & 0xFF);
    }

    public static Arbitrary<FlowData> getFlowDataArbitrary(FlowConfig cfg) {
        Arbitrary flowData1 = Combinators.combine((Arbitrary)Arbitraries.integers().between(cfg.minExporter, cfg.minExporter + cfg.numExporters - 1), (Arbitrary)Arbitraries.integers().between(cfg.minInterface, cfg.minInterface + cfg.numInterfaces - 1), (Arbitrary)Arbitraries.integers().between(cfg.minInterface, cfg.minInterface + cfg.numInterfaces - 1), (Arbitrary)Arbitraries.integers().between(0, cfg.numProtocols - 1), (Arbitrary)Arbitraries.integers().between(0, cfg.numHosts - 1), (Arbitrary)Arbitraries.integers().between(0, cfg.numHosts - 1), (Arbitrary)Arbitraries.integers().between(0, cfg.numApplications - 1)).as(FlowData1::new);
        Arbitrary flowData2 = Combinators.combine((Arbitrary)Arbitraries.of((Object[])new Boolean[]{true, false}), (Arbitrary)NORMAL.map(d -> Duration.millis((long)((long)(d * (double)cfg.lastSwitchedSigma.getMillis())))), (Arbitrary)EXPONENTIAL.map(d -> Duration.millis((long)((long)(d * 1000.0 / cfg.flowDurationLambda)))), BYTES, (Arbitrary)Arbitraries.integers().between(0, cfg.numEcns - 1), (Arbitrary)Arbitraries.integers().between(0, cfg.numDscps - 1)).as(FlowData2::new);
        Arbitrary flowData = Combinators.combine((Arbitrary)flowData1, (Arbitrary)flowData2).as(FlowData::new);
        return flowData;
    }

    public static class FlowData {
        public final FlowData1 fd1;
        public final FlowData2 fd2;

        public FlowData(FlowData1 fd1, FlowData2 fd2) {
            this.fd1 = fd1;
            this.fd2 = fd2;
        }
    }

    public static class FlowData2 {
        public final boolean ingressNotEgress;
        public final Duration lastSwitchedOffset;
        public final Duration flowDuration;
        public final long bytes;
        public final int ecn;
        public final int dscp;

        public FlowData2(boolean ingressNotEgress, Duration lastSwitchedOffset, Duration flowDuration, long bytes, int ecn, int dscp) {
            this.ingressNotEgress = ingressNotEgress;
            this.lastSwitchedOffset = lastSwitchedOffset;
            this.flowDuration = flowDuration;
            this.bytes = bytes;
            this.ecn = ecn;
            this.dscp = dscp;
        }
    }

    public static class FlowData1 {
        public final int nodeId;
        public final int inputInterfaceIdx;
        public final int outputInterfaceIdx;
        public final int protocol;
        public final int srcAddr;
        public final int dstAddr;
        public final int application;

        public FlowData1(int nodeId, int inputInterfaceIdx, int outputInterfaceIdx, int protocol, int srcAddr, int dstAddr, int application) {
            this.nodeId = nodeId;
            this.inputInterfaceIdx = inputInterfaceIdx;
            this.outputInterfaceIdx = outputInterfaceIdx;
            this.protocol = protocol;
            this.srcAddr = srcAddr;
            this.dstAddr = dstAddr;
            this.application = application;
        }
    }
}

