/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.testing.flowgen;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.opennms.nephron.NephronOptions;
import org.opennms.nephron.testing.flowgen.ClockSkewDirection;

public interface FlowGenOptions
extends NephronOptions {
    @Description(value="Seed for generating synthetic flows.")
    @Default.Long(value=123456L)
    public Long getSeed();

    public void setSeed(Long var1);

    @Description(value="Approximate number of flows per window. Overridden in playback mode if flowsPerSecond is specified.")
    @Default.Long(value=1000L)
    public Long getFlowsPerWindow();

    public void setFlowsPerWindow(Long var1);

    @Description(value="The minimum number of splits the input is split into. A single task may use several splits depending on parallelism.")
    @Default.Integer(value=1)
    public Integer getMinSplits();

    public void setMinSplits(Integer var1);

    @Description(value="The maximum number of splits the input is split into. A single task may use several splits depending on parallelism.")
    @Default.Integer(value=1)
    public Integer getMaxSplits();

    public void setMaxSplits(Integer var1);

    @Description(value="Approximate number of windows.")
    @Default.Integer(value=10)
    public Integer getNumWindows();

    public void setNumWindows(Integer var1);

    @Description(value="The minimum exporter number.")
    @Default.Integer(value=2)
    public Integer getMinExporter();

    public void setMinExporter(Integer var1);

    @Description(value="The number of exporters.")
    @Default.Integer(value=5)
    public Integer getNumExporters();

    public void setNumExporters(Integer var1);

    @Description(value="Partition exporters into a number of groups each having its own clock skew.")
    @Default.Integer(value=1)
    public Integer getNumClockSkewGroups();

    public void setNumClockSkewGroups(Integer var1);

    @Description(value="Clock skew difference between different clock skew groups. Must be a positive number.")
    @Default.Long(value=10000L)
    public Long getClockSkewMs();

    public void setClockSkewMs(Long var1);

    @Description(value="Determines if skewed clocks are ahead of time, behind of time, or both.")
    @Default.Enum(value="BOTH")
    public ClockSkewDirection getClockSkewDirection();

    public void setClockSkewDirection(ClockSkewDirection var1);

    @Description(value="The minimum interface number.")
    @Default.Integer(value=3)
    public Integer getMinInterface();

    public void setMinInterface(Integer var1);

    @Description(value="The number of interfaces.")
    @Default.Integer(value=1)
    public Integer getNumInterfaces();

    public void setNumInterfaces(Integer var1);

    @Description(value="The number of applications.")
    @Default.Integer(value=10)
    public Integer getNumProtocols();

    public void setNumProtocols(Integer var1);

    @Description(value="The number of applications.")
    @Default.Integer(value=10)
    public Integer getNumApplications();

    public void setNumApplications(Integer var1);

    @Description(value="The number of hosts.")
    @Default.Integer(value=5)
    public Integer getNumHosts();

    public void setNumHosts(Integer var1);

    @Description(value="The number of ECN values. Values 1 to 4 are allowed.")
    @Default.Integer(value=4)
    public Integer getNumEcns();

    public void setNumEcns(Integer var1);

    @Description(value="The number of DSCP values. Values 1 to 64 are allowed.")
    @Default.Integer(value=17)
    public Integer getNumDscps();

    public void setNumDscps(Integer var1);

    @Description(value="Standard deviation of lastSwitched from its calculated value.")
    @Default.Long(value=0L)
    public Long getLastSwitchedSigmaMs();

    public void setLastSwitchedSigmaMs(Long var1);

    @Description(value="The lambda (decay) factor for the exponential distribution of flow durations (in seconds; larger lambdas yield shorter flow durations).")
    @Default.Double(value=0.5)
    public Double getFlowDurationLambda();

    public void setFlowDurationLambda(Double var1);

    @Description(value="In playback mode calculated timestamps are used. In non-playback mode the current time is used. In playback mode flow generation is completely deterministic.")
    @Default.Boolean(value=true)
    public Boolean getPlaybackMode();

    public void setPlaybackMode(Boolean var1);

    @Description(value="Start timestamp for generated flows. Only considered in playback mode. In non-playback mode current timestamps are used.")
    @Default.Long(value=1500000000000L)
    public Long getStartMs();

    public void setStartMs(Long var1);

    @Description(value="Rate limitation for generating flows. Set to non-positive value to disable. If not set in non-playback mode then it is calculated according to flowsPerWindow and windowSize.")
    @Default.Long(value=0L)
    public Long getFlowsPerSecond();

    public void setFlowsPerSecond(Long var1);
}

