/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.testing.flowgen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.opennms.nephron.testing.flowgen.FlowConfig;
import org.opennms.nephron.testing.flowgen.FlowDocuments;
import org.opennms.nephron.testing.flowgen.FlowGenOptions;
import org.opennms.nephron.testing.flowgen.SyntheticFlowTimestampPolicyFactory;

public class SourceConfig
implements Serializable {
    public final FlowConfig flowConfig;
    public final SyntheticFlowTimestampPolicyFactory timestampPolicyFactory;
    public final long seed;
    public final int minSplits;
    public final int maxSplits;
    public final long maxIdx;
    public final int idxInc;
    public final int idxOffset;
    public final long flowsPerSecond;

    public static SourceConfig of(FlowGenOptions options, SyntheticFlowTimestampPolicyFactory timestampPolicyFactory) {
        SerializableBiFunction<Long, FlowDocuments.FlowData, Instant> lastSwitchedPolicy = options.getPlaybackMode() != false ? FlowConfig.uniformInWindowLastSwitchedPolicy(options) : FlowConfig.CURRENT_TIME_LAST_SWITCHED_POLICY;
        return SourceConfig.of(options, lastSwitchedPolicy, timestampPolicyFactory);
    }

    public static SourceConfig of(FlowGenOptions options, SerializableBiFunction<Long, FlowDocuments.FlowData, Instant> lastSwitchedPolicy, SyntheticFlowTimestampPolicyFactory timestampPolicyFactory) {
        if (!options.getPlaybackMode().booleanValue()) {
            if (options.getFlowsPerSecond() > 0L) {
                options.setFlowsPerWindow(options.getFlowsPerSecond() * options.getFixedWindowSizeMs() / 1000L);
            } else {
                options.setFlowsPerSecond(options.getFlowsPerWindow() * 1000L / options.getFixedWindowSizeMs());
            }
        }
        SerializableFunction<Integer, Duration> clockSkewPolicy = FlowConfig.groupClockSkewPolicy(options);
        return new SourceConfig(new FlowConfig(options, lastSwitchedPolicy, clockSkewPolicy), timestampPolicyFactory, options.getSeed(), options.getMinSplits(), options.getMaxSplits(), (long)options.getNumWindows().intValue() * options.getFlowsPerWindow(), 1, 0, options.getFlowsPerSecond());
    }

    public SourceConfig(FlowConfig flowConfig, SyntheticFlowTimestampPolicyFactory timestampPolicyFactory, long seed, int minSplits, int maxSplits, long maxIdx, int idxInc, int idxOffset, long flowsPerSecond) {
        this.flowConfig = flowConfig;
        this.timestampPolicyFactory = timestampPolicyFactory;
        this.seed = seed;
        this.minSplits = minSplits;
        this.maxSplits = maxSplits;
        this.maxIdx = maxIdx;
        this.idxInc = idxInc;
        this.idxOffset = idxOffset;
        this.flowsPerSecond = flowsPerSecond;
    }

    public List<SourceConfig> split(int desiredNumSplits) {
        int numSplits = Math.max(this.minSplits, Math.min(desiredNumSplits, this.maxSplits));
        ArrayList<SourceConfig> res = new ArrayList<SourceConfig>(numSplits);
        long seed = this.seed;
        for (int i = 0; i < this.maxSplits; ++i) {
            res.add(new SourceConfig(this.flowConfig, this.timestampPolicyFactory, seed, 1, 1, this.maxIdx, numSplits, i, this.flowsPerSecond));
            seed *= seed;
        }
        return res;
    }
}

