/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.testing.flowgen;

import java.util.Optional;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;

public abstract class SyntheticFlowTimestampPolicy {
    public abstract Instant getTimestampForFlow(FlowDocument var1);

    public abstract Instant getWatermark();

    public abstract Instant getCheckpointInstant();

    public static class WithLimitedDelay
    extends SyntheticFlowTimestampPolicy {
        private final Duration maxDelay;
        private final SerializableFunction<FlowDocument, Instant> timestampFunction;
        private Instant maxEventTimestamp;

        public WithLimitedDelay(Duration maxDelay, SerializableFunction<FlowDocument, Instant> timestampFunction, Optional<Instant> previousMaxEventTimestamp) {
            this.maxDelay = maxDelay;
            this.timestampFunction = timestampFunction;
            this.maxEventTimestamp = previousMaxEventTimestamp.orElse(BoundedWindow.TIMESTAMP_MIN_VALUE);
        }

        @Override
        public Instant getTimestampForFlow(FlowDocument fd) {
            Instant ts = (Instant)this.timestampFunction.apply((Object)fd);
            if (ts.isAfter((ReadableInstant)this.maxEventTimestamp)) {
                this.maxEventTimestamp = ts;
            }
            return ts;
        }

        @Override
        public Instant getWatermark() {
            Instant now = Instant.now();
            Instant wm = this.maxEventTimestamp.isAfter((ReadableInstant)now) ? now.minus((ReadableDuration)this.maxDelay) : this.maxEventTimestamp.minus((ReadableDuration)this.maxDelay);
            return wm;
        }

        @Override
        public Instant getCheckpointInstant() {
            return this.maxEventTimestamp;
        }
    }
}

