/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;

public class Resource {
    private final String m_id;
    private final Optional<Map<String, String>> m_attributes;

    public Resource(String id) {
        this(id, (Optional<Map<String, String>>)Optional.absent());
    }

    public Resource(String id, Optional<Map<String, String>> attributes) {
        this.m_id = (String)Preconditions.checkNotNull((Object)id, (Object)"id argument");
        this.m_attributes = (Optional)Preconditions.checkNotNull(attributes, (Object)"attributes argument");
    }

    public String getId() {
        return this.m_id;
    }

    public Optional<Map<String, String>> getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getAttributes()});
    }

    public boolean equals(Object o) {
        if (!(o instanceof Resource)) {
            return false;
        }
        return this.getId().equals(((Resource)o).getId());
    }
}

