/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.newts.api.Timestamp;

public class Duration
implements Comparable<Duration> {
    private static final Pattern s_pattern = Pattern.compile("([\\d]+)([wdhms]|ms)");
    private final long m_duration;
    private final TimeUnit m_unit;

    public Duration(long duration, TimeUnit unit) {
        this.m_duration = duration;
        this.m_unit = unit;
    }

    public long convert(TimeUnit unit) {
        return unit.convert(this.getDuration(), this.getUnit());
    }

    public long asMillis() {
        return this.convert(TimeUnit.MILLISECONDS);
    }

    public long asSeconds() {
        return this.convert(TimeUnit.SECONDS);
    }

    public static Duration days(long days) {
        return new Duration(days, TimeUnit.DAYS);
    }

    public static Duration hours(long hours) {
        return new Duration(hours, TimeUnit.HOURS);
    }

    public static Duration minutes(long minutes) {
        return new Duration(minutes, TimeUnit.MINUTES);
    }

    public static Duration seconds(long seconds) {
        return new Duration(seconds, TimeUnit.SECONDS);
    }

    public static Duration millis(long millis) {
        return new Duration(millis, TimeUnit.MILLISECONDS);
    }

    public static Duration parse(String durationSpec) {
        Duration r;
        String unit;
        Preconditions.checkNotNull((Object)durationSpec, (Object)"durationSpec argument");
        Matcher matcher = s_pattern.matcher(durationSpec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid duration", durationSpec));
        }
        Integer value = Integer.parseInt(matcher.group(1));
        switch (unit = matcher.group(2)) {
            case "w": {
                r = Duration.days(value * 7);
                break;
            }
            case "d": {
                r = Duration.days(value.intValue());
                break;
            }
            case "h": {
                r = Duration.hours(value.intValue());
                break;
            }
            case "m": {
                r = Duration.minutes(value.intValue());
                break;
            }
            case "s": {
                r = Duration.seconds(value.intValue());
                break;
            }
            case "ms": {
                r = Duration.millis(value.intValue());
                break;
            }
            default: {
                throw new RuntimeException(String.format("%s is an unknown unit; this is a bug!", unit));
            }
        }
        return r;
    }

    public long getDuration() {
        return this.m_duration;
    }

    public TimeUnit getUnit() {
        return this.m_unit;
    }

    public Duration plus(Duration o) {
        TimeUnit u = Timestamp.finest(this.getUnit(), o.getUnit());
        return new Duration(this.convert(u) + o.convert(u), u);
    }

    public Duration times(long value) {
        return new Duration(this.getDuration() * value, this.getUnit());
    }

    public long divideBy(Duration o) {
        TimeUnit u = Timestamp.finest(this.getUnit(), o.getUnit());
        return this.convert(u) / o.convert(u);
    }

    public boolean isMultiple(Duration o) {
        TimeUnit u = Timestamp.finest(this.getUnit(), o.getUnit());
        return this.gt(o) && this.convert(u) % o.convert(u) == 0L;
    }

    public String toString() {
        return String.format("%s[%d, %s]", new Object[]{this.getClass().getSimpleName(), this.m_duration, this.getUnit()});
    }

    @Override
    public int compareTo(Duration o) {
        TimeUnit unit = Timestamp.finest(this.getUnit(), o.getUnit());
        return this.convert(unit) < o.convert(unit) ? -1 : (this.convert(unit) > o.convert(unit) ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Duration)) {
            return false;
        }
        return this.compareTo((Duration)o) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.convert(TimeUnit.NANOSECONDS));
    }

    public boolean lt(Duration o) {
        return this.compareTo(o) == -1;
    }

    public boolean gt(Duration o) {
        return this.compareTo(o) == 1;
    }

    public boolean lte(Duration o) {
        return this.compareTo(o) <= 0;
    }

    public boolean gte(Duration o) {
        return this.compareTo(o) >= 0;
    }
}

