/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Timestamp;

public class Measurement
implements Element<Double>,
Serializable {
    private static final long serialVersionUID = 5630616345926189648L;
    private final Timestamp m_timestamp;
    private final Resource m_resource;
    private final String m_name;
    private final double m_value;
    private final Map<String, String> m_attributes;

    public Measurement(Timestamp timestamp, Resource resource, String name, double value) {
        this(timestamp, resource, name, value, null);
    }

    public Measurement(Timestamp timestamp, Resource resource, String name, double value, Map<String, String> attributes) {
        this.m_timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.m_resource = (Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource");
        this.m_name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.m_value = (Double)Preconditions.checkNotNull((Object)value, (Object)"value");
        this.m_attributes = attributes;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public Resource getResource() {
        return this.m_resource;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Double getValue() {
        return this.m_value;
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        return String.format("%s[timestamp=%s, resource=%s, name=%s, value=%s]", this.getClass().getSimpleName(), this.getTimestamp(), this.getResource(), this.getName(), this.getValue());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Measurement other = (Measurement)obj;
        return Objects.equal((Object)this.m_timestamp, (Object)other.m_timestamp) && Objects.equal((Object)this.m_resource, (Object)other.m_resource) && Objects.equal((Object)this.m_name, (Object)other.m_name) && Objects.equal((Object)this.m_value, (Object)other.m_value) && Objects.equal(this.m_attributes, other.m_attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.m_timestamp, this.m_resource, this.m_name, this.m_value, this.m_attributes});
    }
}

