/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.query;

import java.util.Collection;
import org.opennms.newts.api.query.AggregationFunction;

public enum StandardAggregationFunctions implements AggregationFunction
{
    AVERAGE{

        @Override
        public Double apply(Collection<Double> input) {
            int count = 0;
            Double sum = 0.0;
            for (Double item : input) {
                if (Double.isNaN(item)) continue;
                sum = sum + item;
                ++count;
            }
            return sum / (double)count;
        }
    }
    ,
    MAX{

        @Override
        public Double apply(Collection<Double> input) {
            Double max = Double.MIN_VALUE;
            for (Double item : input) {
                if (Double.isNaN(item)) continue;
                double diff = item - max;
                max = diff > 0.0 ? item : max;
            }
            return max;
        }
    }
    ,
    MIN{

        @Override
        public Double apply(Collection<Double> input) {
            Double min = Double.MAX_VALUE;
            for (Double item : input) {
                if (Double.isNaN(item)) continue;
                double diff = item - min;
                min = diff < 0.0 ? item : min;
            }
            return min;
        }
    };

}

