/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Preconditions;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.ValueType;

public class Gauge
extends ValueType<Double> {
    private static final long serialVersionUID = 1L;
    private final Double m_value;

    public Gauge(double value) {
        this.m_value = (Double)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    public Gauge plus(Number value) {
        return new Gauge(this.doubleValue() + value.doubleValue());
    }

    public Gauge minus(Number value) {
        return new Gauge(this.doubleValue() - value.doubleValue());
    }

    @Override
    public ValueType<Double> delta(Number value) {
        return this.minus(value);
    }

    public Gauge times(Number value) {
        return new Gauge(this.doubleValue() * value.doubleValue());
    }

    public Gauge divideBy(Number value) {
        return new Gauge(this.doubleValue() / value.doubleValue());
    }

    @Override
    Double getValue() {
        return this.m_value;
    }

    @Override
    public MetricType getType() {
        return MetricType.GAUGE;
    }

    @Override
    public int intValue() {
        return this.m_value.intValue();
    }

    @Override
    public long longValue() {
        return this.m_value.longValue();
    }

    @Override
    public float floatValue() {
        return this.m_value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.getValue();
    }
}

