/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.query.AggregationFunction;
import org.opennms.newts.api.query.Calculation;
import org.opennms.newts.api.query.CalculationFunction;
import org.opennms.newts.api.query.Datasource;

public class ResultDescriptor
implements Serializable {
    private static final long serialVersionUID = -6983442401680715547L;
    public static final int DEFAULT_STEP = 300000;
    public static final int DEFAULT_HEARTBEAT_MULTIPLIER = 2;
    public static final double DEFAULT_XFF = 0.5;
    private Duration m_interval;
    private final Map<String, Datasource> m_datasources = Maps.newHashMap();
    private final Map<String, Calculation> m_calculations = Maps.newLinkedHashMap();
    private final Set<String> m_exports = Sets.newHashSet();

    public ResultDescriptor() {
        this(300000L);
    }

    public ResultDescriptor(long step) {
        this(Duration.millis(step));
    }

    public ResultDescriptor(Duration step) {
        this.m_interval = step;
    }

    public Duration getInterval() {
        return this.m_interval;
    }

    public Map<String, Datasource> getDatasources() {
        return this.m_datasources;
    }

    public Map<String, Calculation> getCalculations() {
        return this.m_calculations;
    }

    public Set<String> getSourceNames() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.getDatasources().values(), (Function)new Function<Datasource, String>(){

            public String apply(Datasource input) {
                return input.getSource();
            }
        }));
    }

    public Set<String> getLabels() {
        return Sets.union(this.m_datasources.keySet(), this.m_calculations.keySet());
    }

    public Set<String> getExports() {
        return this.m_exports;
    }

    public ResultDescriptor step(long step) {
        return this.step(Duration.millis(step));
    }

    public ResultDescriptor step(Duration step) {
        this.m_interval = step;
        return this;
    }

    public ResultDescriptor datasource(String metricName, AggregationFunction aggregationFunction) {
        return this.datasource(metricName, metricName, aggregationFunction);
    }

    public ResultDescriptor datasource(String name, String metricName, AggregationFunction aggregationFunction) {
        return this.datasource(name, metricName, this.getInterval().times(2L), aggregationFunction);
    }

    public ResultDescriptor datasource(String name, String metricName, long heartbeat, AggregationFunction aggregationFunction) {
        return this.datasource(name, metricName, Duration.millis(heartbeat), aggregationFunction);
    }

    public ResultDescriptor datasource(String name, String metricName, Duration heartbeat, AggregationFunction aggregationFunction) {
        return this.datasource(name, metricName, heartbeat, 0.5, aggregationFunction);
    }

    public ResultDescriptor datasource(String name, String metricName, Duration heartbeat, double xff, AggregationFunction aggregationFunction) {
        return this.datasource(new Datasource(name, metricName, heartbeat, xff, aggregationFunction));
    }

    ResultDescriptor datasource(Datasource ds) {
        Preconditions.checkNotNull((Object)ds, (Object)"data source argument");
        Preconditions.checkArgument((!this.getLabels().contains(ds.getLabel()) ? 1 : 0) != 0, (String)"label \"%s\" already in use", (Object[])new Object[]{ds.getLabel()});
        Preconditions.checkArgument((boolean)ds.getHeartbeat().gte(this.getInterval()), (Object)"heartbeat cannot be smaller than sample interval");
        this.getDatasources().put(ds.getLabel(), ds);
        return this;
    }

    public ResultDescriptor export(String ... names) {
        this.checkLabels(names);
        this.getExports().addAll(Arrays.asList(names));
        return this;
    }

    private void checkLabels(String ... names) {
        HashSet missing = Sets.newHashSet((Object[])names);
        missing.removeAll(this.getLabels());
        if (missing.size() > 0) {
            throw new IllegalArgumentException(String.format("No such labels(s): %s", missing));
        }
    }

    private boolean isNumber(String number) {
        try {
            Double.parseDouble(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void checkValues(String ... values) {
        for (String value : values) {
            if (this.isNumber(value)) continue;
            this.checkLabels(value);
        }
    }

    public ResultDescriptor calculate(Calculation calculation) {
        this.checkValues(calculation.getArgs());
        Preconditions.checkArgument((!this.getLabels().contains(calculation.getLabel()) ? 1 : 0) != 0, (String)"label \"%s\" already in use", (Object[])new Object[]{calculation.getLabel()});
        this.m_calculations.put(calculation.getLabel(), calculation);
        return this;
    }

    public ResultDescriptor calculate(String label, CalculationFunction calculationFunction, String ... args) {
        return this.calculate(new Calculation(label, calculationFunction, args));
    }

    public ResultDescriptor calculate(String label, final BinaryFunction binaryFunction, String arg1, String arg2) {
        CalculationFunction calculationFunction = new CalculationFunction(){
            private static final long serialVersionUID = -4149546450724920349L;

            @Override
            public double apply(double ... ds) {
                Preconditions.checkArgument((ds.length == 2 ? 1 : 0) != 0, (Object)("binaryFunctions expect to take exactly two arguments but we've been passed " + ds.length));
                return binaryFunction.apply(ds[0], ds[1]);
            }
        };
        return this.calculate(label, calculationFunction, arg1, arg2);
    }

    public ResultDescriptor calculate(String label, final UnaryFunction unaryFunction, String arg) {
        CalculationFunction calculationFunction = new CalculationFunction(){
            private static final long serialVersionUID = 2353112913166459161L;

            @Override
            public double apply(double ... ds) {
                Preconditions.checkArgument((ds.length == 1 ? 1 : 0) != 0, (Object)("unaryFunctions expect to take exactly one argument but we've been passed " + ds.length));
                return unaryFunction.apply(ds[0]);
            }
        };
        return this.calculate(label, calculationFunction, arg);
    }

    public ResultDescriptor expression(String label, String expression) {
        JexlEngine je = new JexlEngine();
        final Expression expr = je.createExpression(expression);
        final String[] labels = this.getLabels().toArray(new String[0]);
        CalculationFunction evaluate = new CalculationFunction(){
            private static final long serialVersionUID = -3328049421398096252L;

            @Override
            public double apply(double ... ds) {
                MapContext jc = new MapContext();
                for (int i = 0; i < labels.length; ++i) {
                    jc.set(labels[i], (Object)ds[i]);
                }
                return ((Number)expr.evaluate((JexlContext)jc)).doubleValue();
            }
        };
        return this.calculate(label, evaluate, labels);
    }

    public String toString() {
        return String.format("%s[interval=%s, datasources=%s, calculations=%s, exports=%s]", this.getClass().getSimpleName(), this.getInterval(), this.getDatasources().values(), this.getCalculations().values(), this.getExports());
    }

    public static interface BinaryFunction
    extends Serializable {
        public double apply(double var1, double var3);
    }

    public static interface UnaryFunction
    extends Serializable {
        public double apply(double var1);
    }
}

