/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.ObjectBuffer;

public final class ObjectParameterInfo {
    private final int parameterIndex;
    private final ComponentType componentType;
    private final int objectInfo;
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int PINNED = 8;
    public static final int NULTERMINATE = 4;
    public static final int CLEAR = 16;
    public static final ObjectType ARRAY = new ObjectType(0x10000000);
    public static final ObjectType BUFFER = new ObjectType(0x20000000);
    public static final ComponentType BYTE = new ComponentType(0x1000000);
    public static final ComponentType SHORT = new ComponentType(0x2000000);
    public static final ComponentType INT = new ComponentType(0x3000000);
    public static final ComponentType LONG = new ComponentType(0x4000000);
    public static final ComponentType FLOAT = new ComponentType(0x5000000);
    public static final ComponentType DOUBLE = new ComponentType(0x6000000);
    public static final ComponentType BOOLEAN = new ComponentType(0x7000000);
    public static final ComponentType CHAR = new ComponentType(0x8000000);

    public static ObjectParameterInfo create(int parameterIndex, ObjectType objectType, ComponentType componentType, int ioflags) {
        return new ObjectParameterInfo(parameterIndex, objectType, componentType, ioflags);
    }

    private ObjectParameterInfo(int parameterIndex, ObjectType objectType, ComponentType componentType, int ioflags) {
        this.parameterIndex = parameterIndex;
        this.componentType = componentType;
        this.objectInfo = ObjectBuffer.makeObjectFlags(ioflags, objectType.value | componentType.value, parameterIndex);
    }

    final int asObjectInfo() {
        return this.objectInfo;
    }

    public final int getParameterIndex() {
        return this.parameterIndex;
    }

    public static final class ComponentType {
        final int value;

        ComponentType(int type) {
            this.value = type;
        }
    }

    public static final class ObjectType {
        final int value;

        ObjectType(int type) {
            this.value = type;
        }
    }
}

