/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.ContextRoutingHandler;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.server.AbstractServerFactory;
import io.dropwizard.setup.Environment;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hibernate.validator.constraints.NotEmpty;

@JsonTypeName(value="simple")
public class SimpleServerFactory
extends AbstractServerFactory {
    @Valid
    @NotNull
    private ConnectorFactory connector = HttpConnectorFactory.application();
    @NotEmpty
    private String applicationContextPath = "/application";
    @NotEmpty
    private String adminContextPath = "/admin";

    @JsonProperty
    public ConnectorFactory getConnector() {
        return this.connector;
    }

    @JsonProperty
    public void setConnector(ConnectorFactory factory) {
        this.connector = factory;
    }

    @JsonProperty
    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    @JsonProperty
    public void setApplicationContextPath(String contextPath) {
        this.applicationContextPath = contextPath;
    }

    @JsonProperty
    public String getAdminContextPath() {
        return this.adminContextPath;
    }

    @JsonProperty
    public void setAdminContextPath(String contextPath) {
        this.adminContextPath = contextPath;
    }

    @Override
    public Server build(Environment environment) {
        this.printBanner(environment.getName());
        ThreadPool threadPool = this.createThreadPool(environment.metrics());
        Server server = this.buildServer(environment.lifecycle(), threadPool);
        environment.getApplicationContext().setContextPath(this.applicationContextPath);
        Handler applicationHandler = this.createAppServlet(server, environment.jersey(), environment.getObjectMapper(), environment.getValidator(), environment.getApplicationContext(), environment.getJerseyServletContainer(), environment.metrics());
        environment.getAdminContext().setContextPath(this.adminContextPath);
        Handler adminHandler = this.createAdminServlet(server, environment.getAdminContext(), environment.metrics(), environment.healthChecks());
        Connector conn = this.connector.build(server, environment.metrics(), environment.getName(), null);
        server.addConnector(conn);
        ContextRoutingHandler routingHandler = new ContextRoutingHandler((Map)ImmutableMap.of((Object)this.applicationContextPath, (Object)applicationHandler, (Object)this.adminContextPath, (Object)adminHandler));
        server.setHandler(this.addStatsHandler(this.addRequestLog(server, (Handler)routingHandler, environment.getName())));
        return server;
    }
}

