/*
 * Decompiled with CFR 0.152.
 */
package org.skife.gressil;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.skife.gressil.ArgvFinder;

class LinuxArgvFinder
implements ArgvFinder {
    private final int pid;

    LinuxArgvFinder(int pid) {
        this.pid = pid;
    }

    @Override
    public List<String> getArgv() {
        String cmdline;
        File procfs_file = new File("/proc/" + this.pid + "/cmdline");
        try {
            cmdline = LinuxArgvFinder.readFile(procfs_file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to access " + procfs_file.getAbsolutePath());
        }
        return new ArrayList<String>(Arrays.asList(cmdline.split("\u0000")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File f) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream fin = new FileInputStream(f);){
            int sz;
            byte[] buf = new byte[1024];
            while ((sz = fin.read(buf)) >= 0) {
                baos.write(buf, 0, sz);
            }
            String string = baos.toString();
            return string;
        }
    }
}

