/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseReporterFactory;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

@JsonTypeName(value="log")
public class Slf4jReporterFactory
extends BaseReporterFactory {
    @NotEmpty
    private String loggerName = "metrics";
    private String markerName;

    @JsonProperty(value="logger")
    public String getLoggerName() {
        return this.loggerName;
    }

    @JsonProperty(value="logger")
    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getLoggerName());
    }

    @JsonProperty
    public String getMarkerName() {
        return this.markerName;
    }

    @JsonProperty
    public void setMarkerName(String markerName) {
        this.markerName = markerName;
    }

    @Override
    public ScheduledReporter build(MetricRegistry registry) {
        Slf4jReporter.Builder builder = Slf4jReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).outputTo(this.getLogger());
        if (this.markerName != null) {
            builder.markWith(MarkerFactory.getMarker((String)this.markerName));
        }
        return builder.build();
    }
}

