/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.exceptions.DriverInternalError;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.EnumSet;
import java.util.List;

class Frame {
    public final Header header;
    public final ByteBuf body;

    private Frame(Header header, ByteBuf body) {
        this.header = header;
        this.body = body;
    }

    private static Frame create(ByteBuf fullFrame) {
        assert (fullFrame.readableBytes() >= 1) : String.format("Frame too short (%d bytes)", fullFrame.readableBytes());
        byte versionBytes = fullFrame.readByte();
        ProtocolVersion version = ProtocolVersion.fromInt(versionBytes & 0x7F);
        int hdrLen = Header.lengthFor(version);
        assert (fullFrame.readableBytes() >= hdrLen - 1) : String.format("Frame too short (%d bytes)", fullFrame.readableBytes());
        byte flags = fullFrame.readByte();
        int streamId = Frame.readStreamid(fullFrame, version);
        byte opcode = fullFrame.readByte();
        int length = fullFrame.readInt();
        assert (length == fullFrame.readableBytes());
        Header header = new Header(version, flags, streamId, (int)opcode);
        return new Frame(header, fullFrame);
    }

    private static int readStreamid(ByteBuf fullFrame, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return fullFrame.readByte();
            }
            case V3: {
                return fullFrame.readShort();
            }
        }
        throw version.unsupported();
    }

    public static Frame create(ProtocolVersion version, int opcode, int streamId, EnumSet<Header.Flag> flags, ByteBuf body) {
        Header header = new Header(version, flags, streamId, opcode);
        return new Frame(header, body);
    }

    public Frame with(ByteBuf newBody) {
        return new Frame(this.header, newBody);
    }

    public static class Compressor
    extends MessageToMessageEncoder<Frame> {
        private final FrameCompressor compressor;

        public Compressor(FrameCompressor compressor) {
            assert (compressor != null);
            this.compressor = compressor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void encode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            if (frame.header.opcode == Message.Request.Type.STARTUP.opcode) {
                out.add(frame);
            } else {
                frame.header.flags.add(Header.Flag.COMPRESSED);
                ByteBuf uncompressedBody = frame.body;
                try {
                    out.add(this.compressor.compress(frame));
                }
                finally {
                    uncompressedBody.release();
                }
            }
        }
    }

    public static class Decompressor
    extends MessageToMessageDecoder<Frame> {
        private final FrameCompressor compressor;

        public Decompressor(FrameCompressor compressor) {
            assert (compressor != null);
            this.compressor = compressor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            if (frame.header.flags.contains((Object)Header.Flag.COMPRESSED)) {
                ByteBuf compressedBody = frame.body;
                try {
                    out.add(this.compressor.decompress(frame));
                }
                finally {
                    compressedBody.release();
                }
            } else {
                out.add(frame);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class Encoder
    extends MessageToMessageEncoder<Frame> {
        protected void encode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            ProtocolVersion protocolVersion = frame.header.version;
            ByteBuf header = ctx.alloc().ioBuffer(Header.lengthFor(protocolVersion));
            header.writeByte(frame.header.version.toInt());
            header.writeByte(Header.Flag.serialize(frame.header.flags));
            this.writeStreamId(frame.header.streamId, header, protocolVersion);
            header.writeByte(frame.header.opcode);
            header.writeInt(frame.body.readableBytes());
            out.add(header);
            out.add(frame.body);
        }

        private void writeStreamId(int streamId, ByteBuf header, ProtocolVersion protocolVersion) {
            switch (protocolVersion) {
                case V1: 
                case V2: {
                    header.writeByte(streamId);
                    break;
                }
                case V3: {
                    header.writeShort(streamId);
                    break;
                }
                default: {
                    throw protocolVersion.unsupported();
                }
            }
        }
    }

    public static final class Decoder
    extends ByteToMessageDecoder {
        static final DecoderForStreamIdSize decoderV1 = new DecoderForStreamIdSize(1);
        static final DecoderForStreamIdSize decoderV3 = new DecoderForStreamIdSize(2);

        protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
            if (buffer.readableBytes() < 1) {
                return;
            }
            int version = buffer.getByte(0);
            DecoderForStreamIdSize decoder = (version &= 0x7F) >= 3 ? decoderV3 : decoderV1;
            Object frame = decoder.decode(ctx, buffer);
            if (frame != null) {
                out.add(frame);
            }
        }

        static class DecoderForStreamIdSize
        extends LengthFieldBasedFrameDecoder {
            private static final int MAX_FRAME_LENGTH = 0x10000000;
            private final int opcodeOffset;

            DecoderForStreamIdSize(int streamIdSize) {
                super(0x10000000, 3 + streamIdSize, 4, 0, 0, true);
                this.opcodeOffset = 2 + streamIdSize;
            }

            protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
                try {
                    if (buffer.readableBytes() < this.opcodeOffset + 1) {
                        return null;
                    }
                    Message.Response.Type.fromOpcode(buffer.getByte(this.opcodeOffset));
                    ByteBuf frame = (ByteBuf)super.decode(ctx, buffer);
                    if (frame == null) {
                        return null;
                    }
                    return Frame.create(frame);
                }
                catch (CorruptedFrameException e) {
                    throw new DriverInternalError(e.getMessage());
                }
                catch (TooLongFrameException e) {
                    throw new DriverInternalError(e.getMessage());
                }
            }
        }
    }

    public static class Header {
        public final ProtocolVersion version;
        public final EnumSet<Flag> flags;
        public final int streamId;
        public final int opcode;

        private Header(ProtocolVersion version, int flags, int streamId, int opcode) {
            this(version, Flag.deserialize(flags), streamId, opcode);
        }

        private Header(ProtocolVersion version, EnumSet<Flag> flags, int streamId, int opcode) {
            this.version = version;
            this.flags = flags;
            this.streamId = streamId;
            this.opcode = opcode;
        }

        public static int lengthFor(ProtocolVersion version) {
            switch (version) {
                case V1: 
                case V2: {
                    return 8;
                }
                case V3: {
                    return 9;
                }
            }
            throw version.unsupported();
        }

        public static enum Flag {
            COMPRESSED,
            TRACING;


            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                Flag[] values = Flag.values();
                for (int n = 0; n < 8; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(values[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }
        }
    }
}

