/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.ChainableLoadBalancingPolicy;
import com.datastax.driver.core.policies.CloseableLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class WhiteListPolicy
implements ChainableLoadBalancingPolicy,
CloseableLoadBalancingPolicy {
    private final LoadBalancingPolicy childPolicy;
    private final Set<InetSocketAddress> whiteList;

    public WhiteListPolicy(LoadBalancingPolicy childPolicy, Collection<InetSocketAddress> whiteList) {
        this.childPolicy = childPolicy;
        this.whiteList = ImmutableSet.copyOf(whiteList);
    }

    @Override
    public LoadBalancingPolicy getChildPolicy() {
        return this.childPolicy;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        ArrayList<Host> whiteHosts = new ArrayList<Host>(hosts.size());
        for (Host host : hosts) {
            if (!this.whiteList.contains(host.getSocketAddress())) continue;
            whiteHosts.add(host);
        }
        if (whiteHosts.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot use WhiteListPolicy where the white list (%s) contains none of the contacts points (%s)", this.whiteList, hosts));
        }
        this.childPolicy.init(cluster, whiteHosts);
    }

    @Override
    public HostDistance distance(Host host) {
        return this.whiteList.contains(host.getSocketAddress()) ? this.childPolicy.distance(host) : HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        return this.childPolicy.newQueryPlan(loggedKeyspace, statement);
    }

    @Override
    public void onUp(Host host) {
        if (this.whiteList.contains(host.getSocketAddress())) {
            this.childPolicy.onUp(host);
        }
    }

    @Override
    public void onSuspected(Host host) {
        if (this.whiteList.contains(host.getSocketAddress())) {
            this.childPolicy.onSuspected(host);
        }
    }

    @Override
    public void onDown(Host host) {
        if (this.whiteList.contains(host.getSocketAddress())) {
            this.childPolicy.onDown(host);
        }
    }

    @Override
    public void onAdd(Host host) {
        if (this.whiteList.contains(host.getSocketAddress())) {
            this.childPolicy.onAdd(host);
        }
    }

    @Override
    public void onRemove(Host host) {
        if (this.whiteList.contains(host.getSocketAddress())) {
            this.childPolicy.onRemove(host);
        }
    }

    @Override
    public void close() {
        if (this.childPolicy instanceof CloseableLoadBalancingPolicy) {
            ((CloseableLoadBalancingPolicy)this.childPolicy).close();
        }
    }
}

