/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Function;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeConverter;
import org.objectweb.asm.ClassVisitor;

class AsmBuilder {
    private final String classNamePath;
    private final ClassVisitor classVisitor;
    private final List<ToNativeConverter> toNativeConverters = new ArrayList<ToNativeConverter>();
    private final List<FromNativeConverter> fromNativeConverters = new ArrayList<FromNativeConverter>();
    private final Map<ToNativeConverter, String> toNativeConverterNames = new IdentityHashMap<ToNativeConverter, String>();
    private final Map<FromNativeConverter, String> fromNativeConverterNames = new IdentityHashMap<FromNativeConverter, String>();
    private final Map<Function, String> functionFieldNames = new IdentityHashMap<Function, String>();

    AsmBuilder(String classNamePath, ClassVisitor classVisitor) {
        this.classNamePath = classNamePath;
        this.classVisitor = classVisitor;
    }

    public String getClassNamePath() {
        return this.classNamePath;
    }

    ClassVisitor getClassVisitor() {
        return this.classVisitor;
    }

    void addFunctionField(Function function, String functionFieldName) {
        this.functionFieldNames.put(function, functionFieldName);
    }

    String getResultConverterName(FromNativeConverter converter) {
        String name = this.fromNativeConverterNames.get(converter);
        if (name == null) {
            int idx = this.fromNativeConverters.size();
            name = "fromNativeConverter" + idx;
            this.fromNativeConverters.add(converter);
            this.fromNativeConverterNames.put(converter, name);
        }
        return name;
    }

    String getParameterConverterName(ToNativeConverter converter) {
        String name = this.toNativeConverterNames.get(converter);
        if (name == null) {
            int idx = this.toNativeConverters.size();
            name = "toNativeConverter" + idx;
            this.toNativeConverters.add(converter);
            this.toNativeConverterNames.put(converter, name);
        }
        return name;
    }

    String getFunctionFieldName(Function function) {
        String name = this.functionFieldNames.get(function);
        if (name == null) {
            throw new IllegalStateException("no function name registered for " + function);
        }
        return name;
    }

    FromNativeConverter[] getFromNativeConverterArray() {
        return this.fromNativeConverters.toArray(new FromNativeConverter[this.fromNativeConverters.size()]);
    }

    ToNativeConverter[] getToNativeConverterArray() {
        return this.toNativeConverters.toArray(new ToNativeConverter[this.toNativeConverters.size()]);
    }
}

