/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import jnr.ffi.Address;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.Signature;

final class FastIntMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final int MAX_FASTINT_PARAMETERS = FastIntMethodGenerator.getMaximumFastIntParameters();
    private static final String[] signatures;
    private static final String[] methodNames;
    private static final String[] noErrnoMethodNames;

    FastIntMethodGenerator(BufferMethodGenerator bufgen) {
        super(bufgen);
    }

    String getInvokerMethodName(Class returnType, Annotation[] resultAnnotations, Class[] parameterTypes, Annotation[][] parameterAnnotations, boolean ignoreErrno) {
        int parameterCount = parameterTypes.length;
        if (ignoreErrno && parameterCount <= MAX_FASTINT_PARAMETERS && parameterCount <= noErrnoMethodNames.length) {
            return noErrnoMethodNames[parameterTypes.length];
        }
        if (parameterCount <= MAX_FASTINT_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    String getInvokerSignature(int parameterCount, Class nativeIntType) {
        if (parameterCount <= MAX_FASTINT_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    final Class getInvokerType() {
        return Integer.TYPE;
    }

    public boolean isSupported(Signature signature) {
        int parameterCount = signature.parameterTypes.length;
        if (!signature.callingConvention.equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_FASTINT_PARAMETERS) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform.getCPU().equals((Object)Platform.CPU.I386) && !platform.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (FastIntMethodGenerator.isFastIntParameter(platform, signature.parameterTypes[i], signature.parameterAnnotations[i])) continue;
            return false;
        }
        return FastIntMethodGenerator.isFastIntResult(platform, signature.resultType, signature.resultAnnotations);
    }

    static final int getMaximumFastIntParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeIIIIIIrI", Function.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return 6;
        }
        catch (NoSuchMethodException nex) {
            try {
                Invoker.class.getDeclaredMethod("invokeIIIrI", Function.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return 3;
            }
            catch (NoSuchMethodException nex2) {
                return 0;
            }
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static boolean isFastIntType(Platform platform, Class type, Annotation[] annotations) {
        return Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type || Byte.class.isAssignableFrom(type) || Byte.TYPE == type || Short.class.isAssignableFrom(type) || Short.TYPE == type || Integer.class.isAssignableFrom(type) || Integer.TYPE == type || NumberUtil.isLong32(platform, type, annotations) || Address.class == type && platform.addressSize() == 32 || Pointer.class.isAssignableFrom(type) && platform.addressSize() == 32 || Struct.class.isAssignableFrom(type) && platform.addressSize() == 32 || Buffer.class.isAssignableFrom(type) && platform.addressSize() == 32;
    }

    static boolean isFastIntResult(Platform platform, Class type, Annotation[] annotations) {
        return FastIntMethodGenerator.isFastIntType(platform, type, annotations) || Void.class.isAssignableFrom(type) || Void.TYPE == type || platform.addressSize() == 32 && String.class.isAssignableFrom(type);
    }

    static boolean isFastIntParameter(Platform platform, Class type, Annotation[] annotations) {
        return FastIntMethodGenerator.isFastIntType(platform, type, annotations) || AsmUtil.isDelegate(type) && platform.addressSize() == 32;
    }

    static {
        methodNames = new String[]{"invokeVrI", "invokeIrI", "invokeIIrI", "invokeIIIrI", "invokeIIIIrI", "invokeIIIIIrI", "invokeIIIIIIrI"};
        noErrnoMethodNames = new String[]{"invokeNoErrnoVrI", "invokeNoErrnoIrI", "invokeNoErrnoIIrI", "invokeNoErrnoIIIrI"};
        signatures = new String[MAX_FASTINT_PARAMETERS + 1];
        for (int i = 0; i <= MAX_FASTINT_PARAMETERS; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(Function.class));
            for (int n = 0; n < i; ++n) {
                sb.append('I');
            }
            FastIntMethodGenerator.signatures[i] = sb.append(")I").toString();
        }
    }
}

