/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.IOUtils;

public class Lucene46SegmentInfoReader
extends SegmentInfoReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, IOContext context) throws IOException {
        SegmentInfo segmentInfo;
        block8: {
            ChecksumIndexInput input;
            block7: {
                String fileName = IndexFileNames.segmentFileName(segment, "", "si");
                input = dir.openChecksumInput(fileName, context);
                boolean success = false;
                try {
                    int codecVersion = CodecUtil.checkHeader(input, "Lucene46SegmentInfo", 0, 1);
                    String version = input.readString();
                    int docCount = input.readInt();
                    if (docCount < 0) {
                        throw new CorruptIndexException("invalid docCount: " + docCount + " (resource=" + input + ")");
                    }
                    boolean isCompoundFile = input.readByte() == 1;
                    Map<String, String> diagnostics = input.readStringStringMap();
                    Set<String> files = input.readStringSet();
                    if (codecVersion >= 1) {
                        CodecUtil.checkFooter(input);
                    } else {
                        CodecUtil.checkEOF(input);
                    }
                    SegmentInfo si = new SegmentInfo(dir, version, segment, docCount, isCompoundFile, null, diagnostics);
                    si.setFiles(files);
                    success = true;
                    segmentInfo = si;
                    if (success) break block7;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(input);
                    } else {
                        input.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(input);
                break block8;
            }
            input.close();
        }
        return segmentInfo;
    }
}

