/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.opennms.newts.rest.NewtsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(HttpBasicAuthenticationFilter.class);
    private static final String m_realm = "Newts";
    private final NewtsConfig m_config;

    public HttpBasicAuthenticationFilter(NewtsConfig config) {
        this.m_config = (NewtsConfig)((Object)Preconditions.checkNotNull((Object)((Object)config), (Object)"config argument"));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("HTTP Basic Auth servlet filter initialized");
    }

    public void destroy() {
        LOG.info("Shutting down HTTP Basic Auth servlet filter");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        LOG.trace("doFilter()");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (this.enabled() && !this.isCorsPreflight(request)) {
            LOG.trace("Authentication is enabled");
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            Optional<String> authHeader = HttpBasicAuthenticationFilter.getAuthorizationHeader(request);
            if (!authHeader.isPresent()) {
                LOG.trace("Missing Authorization HTTP header; Authorization failed");
                this.sendUnauthorized(response);
                return;
            }
            Credentials credentials = Credentials.fromHeader((String)authHeader.get());
            if (!this.isAuthorized(credentials)) {
                LOG.trace("Credentials do NOT match; Authorizationi failed");
                this.sendUnauthorized(response);
                return;
            }
            LOG.trace("User {} is authorized", (Object)credentials.getUser());
        } else {
            LOG.trace("Authentication is NOT enabled (skipping...)");
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    private void sendUnauthorized(HttpServletResponse response) throws IOException {
        this.sendUnauthorized(response, "Unauthorized");
    }

    private void sendUnauthorized(HttpServletResponse response, String msg) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"Newts\"");
        response.sendError(401, msg);
    }

    private boolean isAuthorized(Credentials credentials) {
        Map<String, String> passwords = this.m_config.getAuthenticationConfig().getCredentials();
        String user = credentials.getUser();
        String pass = credentials.getPass();
        if (passwords.containsKey(user) && passwords.get(user) != null) {
            return passwords.get(user).equals(pass);
        }
        return false;
    }

    private boolean isCorsPreflight(HttpServletRequest request) {
        return request.getMethod().equals("OPTIONS") && request.getHeader("Access-Control-Request-Method") != null;
    }

    private boolean enabled() {
        return this.m_config.getAuthenticationConfig().isEnabled();
    }

    private static Optional<String> getAuthorizationHeader(HttpServletRequest request) {
        String v = HttpBasicAuthenticationFilter.trim(request.getHeader("Authorization"));
        return v != null ? Optional.of((Object)v) : Optional.absent();
    }

    private static String trim(String s) {
        return s != null ? s.trim() : s;
    }

    static class Credentials {
        private static final Pattern s_headerPattern = Pattern.compile("Basic (?<token>.+)", 2);
        private static final Pattern s_credsPattern = Pattern.compile("(?<user>.+):(?<pass>.+)");
        private final String m_user;
        private final String m_pass;

        Credentials(String user, String pass) {
            this.m_user = (String)Preconditions.checkNotNull((Object)user, (Object)"user argument");
            this.m_pass = (String)Preconditions.checkNotNull((Object)pass, (Object)"pass argument");
        }

        String getUser() {
            return this.m_user;
        }

        String getPass() {
            return this.m_pass;
        }

        static Credentials fromHeader(String headerValue) {
            String decoded;
            Matcher matcher = s_headerPattern.matcher(headerValue);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("malformed credentials header");
            }
            String encoded = matcher.group("token");
            try {
                decoded = new String(Base64.decodeBase64((String)encoded), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw Throwables.propagate((Throwable)e);
            }
            matcher = s_credsPattern.matcher(decoded);
            if (matcher.matches()) {
                return new Credentials(matcher.group("user"), matcher.group("pass"));
            }
            throw new IllegalArgumentException("malformed credentials header");
        }
    }
}

