/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.query.StandardAggregationFunctions;

public class ResultDescriptorDTO {
    @JsonProperty(value="interval")
    private String m_interval = "300s";
    @Valid
    @JsonProperty(value="datasources")
    private Datasource[] m_datasources = new Datasource[0];
    @Valid
    @JsonProperty(value="expressions")
    private Expression[] m_expressions = new Expression[0];
    @NotEmpty
    @JsonProperty(value="exports")
    private String[] m_exports;

    public Duration getInterval() {
        return Duration.parse((String)this.m_interval);
    }

    public Datasource[] getDatasources() {
        return this.m_datasources;
    }

    public Expression[] getExpressions() {
        return this.m_expressions;
    }

    public String[] getExports() {
        return this.m_exports;
    }

    public String toString() {
        return String.format("%s[interval=%s, datasources=%s, expressions=%s, exports=%s]", this.getClass().getSimpleName(), this.getInterval(), Arrays.asList(this.getDatasources()), Arrays.asList(this.getExpressions()), Arrays.asList(this.getExports()));
    }

    public static class Expression {
        @NotEmpty
        @JsonProperty(value="label")
        private String m_label;
        @NotEmpty
        @JsonProperty(value="expression")
        private String m_expression;

        public String getLabel() {
            return this.m_label;
        }

        public String getExpression() {
            return this.m_expression;
        }

        public String toString() {
            return String.format("%s[label=%s, expression=%s]", this.getClass().getSimpleName(), this.getLabel());
        }
    }

    public static class Datasource {
        @NotEmpty
        @JsonProperty(value="label")
        private String m_label;
        @NotEmpty
        @JsonProperty(value="source")
        private String m_source;
        @NotNull
        @JsonProperty(value="function")
        private StandardAggregationFunctions m_function;
        @JsonProperty(value="heartbeat")
        private String m_heartbeat;

        public String getLabel() {
            return this.m_label;
        }

        public String getSource() {
            return this.m_source;
        }

        public StandardAggregationFunctions getFunction() {
            return this.m_function;
        }

        public Duration getHeartbeat() {
            return Duration.parse((String)this.m_heartbeat);
        }

        public String toString() {
            return String.format("%s[label=%s, source=%s, function=%s, heartbeat=%s]", this.getClass().getSimpleName(), this.getLabel(), this.getSource(), this.getFunction(), this.getHeartbeat());
        }
    }
}

