/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.persistence.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.aggregate.IntervalGenerator;
import org.opennms.newts.aggregate.ResultProcessor;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleProcessorService;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.persistence.cassandra.ConcurrentResultWrapper;
import org.opennms.newts.persistence.cassandra.ContextConfigurations;
import org.opennms.newts.persistence.cassandra.DriverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSampleRepository
implements SampleRepository {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSampleRepository.class);
    private static final int TARGET_NUMBER_OF_STEPS = 10;
    private final CassandraSession m_session;
    private final int m_ttl;
    private final SampleProcessorService m_processorService;
    private final PreparedStatement m_selectStatement;
    private final Timer m_sampleSelectTimer;
    private final Timer m_measurementSelectTimer;
    private final Timer m_insertTimer;
    private final ContextConfigurations m_contextConfigurations;

    @Inject
    public CassandraSampleRepository(CassandraSession session, @Named(value="samples.cassandra.time-to-live") int ttl, MetricRegistry registry, SampleProcessorService processorService, ContextConfigurations contextConfigurations) {
        this.m_session = (CassandraSession)Preconditions.checkNotNull((Object)session, (Object)"session argument");
        Preconditions.checkArgument((ttl >= 0 ? 1 : 0) != 0, (Object)"Negative Cassandra column TTL");
        this.m_ttl = ttl;
        Preconditions.checkNotNull((Object)registry, (Object)"metric registry argument");
        this.m_processorService = processorService;
        this.m_contextConfigurations = (ContextConfigurations)Preconditions.checkNotNull((Object)contextConfigurations, (Object)"contextConfigurations argument");
        Select select = QueryBuilder.select().from("samples");
        select.where(QueryBuilder.eq((String)"context", (Object)QueryBuilder.bindMarker((String)"context")));
        select.where(QueryBuilder.eq((String)"partition", (Object)QueryBuilder.bindMarker((String)"partition")));
        select.where(QueryBuilder.eq((String)"resource", (Object)QueryBuilder.bindMarker((String)"resource")));
        select.where(QueryBuilder.gte((String)"collected_at", (Object)QueryBuilder.bindMarker((String)"start")));
        select.where(QueryBuilder.lte((String)"collected_at", (Object)QueryBuilder.bindMarker((String)"end")));
        this.m_selectStatement = this.m_session.prepare(select.toString());
        this.m_sampleSelectTimer = registry.timer(this.metricName("sample-select-timer"));
        this.m_measurementSelectTimer = registry.timer(this.metricName("measurement-select-timer"));
        this.m_insertTimer = registry.timer(this.metricName("insert-timer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results<Measurement> select(Context context, Resource resource, Optional<Timestamp> start, Optional<Timestamp> end, ResultDescriptor descriptor, Optional<Duration> resolution) {
        Duration step;
        Timestamp lower;
        Timer.Context timer = this.m_measurementSelectTimer.time();
        this.validateSelect(start, end);
        Timestamp upper = end.isPresent() ? (Timestamp)end.get() : Timestamp.now();
        Timestamp timestamp = lower = start.isPresent() ? (Timestamp)start.get() : upper.minus(Duration.seconds((long)86400L));
        if (resolution.isPresent()) {
            step = (Duration)resolution.get();
        } else {
            long stepMillis = upper.minus(lower).asMillis() / 10L;
            long intervalMillis = descriptor.getInterval().asMillis();
            if (intervalMillis >= stepMillis) {
                step = descriptor.getInterval().times(2L);
            } else {
                long remainderMillis = stepMillis % intervalMillis;
                if (remainderMillis != 0L) {
                    stepMillis = stepMillis + intervalMillis - remainderMillis;
                }
                step = Duration.millis((long)stepMillis);
            }
        }
        LOG.debug("Querying database for resource {}, from {} to {}", new Object[]{resource, lower.minus(step), upper});
        DriverAdapter driverAdapter = new DriverAdapter(this.cassandraSelect(context, resource, lower.minus(step), upper), descriptor.getSourceNames());
        Results results = new ResultProcessor(resource, lower, upper, descriptor, step).process((Iterator)driverAdapter);
        LOG.debug("{} results returned from database", (Object)driverAdapter.getResultCount());
        try {
            Results results2 = results;
            return results2;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results<Sample> select(Context context, Resource resource, Optional<Timestamp> start, Optional<Timestamp> end) {
        Timer.Context timer = this.m_sampleSelectTimer.time();
        this.validateSelect(start, end);
        Timestamp upper = end.isPresent() ? (Timestamp)end.get() : Timestamp.now();
        Timestamp lower = start.isPresent() ? (Timestamp)start.get() : upper.minus(Duration.seconds((long)86400L));
        LOG.debug("Querying database for resource {}, from {} to {}", new Object[]{resource, lower, upper});
        Results samples = new Results();
        DriverAdapter driverAdapter = new DriverAdapter(this.cassandraSelect(context, resource, lower, upper));
        for (Results.Row<Sample> row : driverAdapter) {
            samples.addRow(row);
        }
        LOG.debug("{} results returned from database", (Object)driverAdapter.getResultCount());
        try {
            Results results = samples;
            return results;
        }
        finally {
            timer.stop();
        }
    }

    public void insert(Collection<Sample> samples) {
        this.insert(samples, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Collection<Sample> samples, boolean calculateTimeToLive) {
        Timer.Context timer = this.m_insertTimer.time();
        Timestamp now = Timestamp.now();
        Batch batch = QueryBuilder.unloggedBatch((RegularStatement[])new RegularStatement[0]);
        for (Sample m : samples) {
            int ttl = this.m_ttl;
            if (calculateTimeToLive && (ttl -= (int)now.minus(m.getTimestamp()).asSeconds()) <= 0) {
                LOG.debug("Skipping expired sample: {}", (Object)m);
                continue;
            }
            Duration resourceShard = this.m_contextConfigurations.getResourceShard(m.getContext());
            batch.add((RegularStatement)QueryBuilder.insertInto((String)"samples").value("context", (Object)m.getContext().getId()).value("partition", (Object)m.getTimestamp().stepFloor(resourceShard).asSeconds()).value("resource", (Object)m.getResource().getId()).value("collected_at", (Object)m.getTimestamp().asMillis()).value("metric_name", (Object)m.getName()).value("value", (Object)ValueType.decompose((ValueType)m.getValue())).value("attributes", (Object)m.getAttributes()).using(QueryBuilder.ttl((int)ttl)));
        }
        try {
            this.m_session.execute((Statement)batch);
            if (this.m_processorService != null) {
                this.m_processorService.submit(samples);
            }
        }
        finally {
            timer.stop();
        }
    }

    private Iterator<Row> cassandraSelect(Context context, Resource resource, Timestamp start, Timestamp end) {
        ArrayList futures = Lists.newArrayList();
        Duration resourceShard = this.m_contextConfigurations.getResourceShard(context);
        Timestamp lower = start.stepFloor(resourceShard);
        Timestamp upper = end.stepFloor(resourceShard);
        for (Timestamp partition : new IntervalGenerator(lower, upper, resourceShard)) {
            BoundStatement bindStatement = this.m_selectStatement.bind();
            bindStatement.setString("context", context.getId());
            bindStatement.setInt("partition", (int)partition.asSeconds());
            bindStatement.setString("resource", resource.getId());
            bindStatement.setDate("start", start.asDate());
            bindStatement.setDate("end", end.asDate());
            futures.add(this.m_session.executeAsync((Statement)bindStatement));
        }
        return new ConcurrentResultWrapper(futures);
    }

    private void validateSelect(Optional<Timestamp> start, Optional<Timestamp> end) {
        if (start.isPresent() && end.isPresent() && ((Timestamp)start.get()).gt((Timestamp)end.get())) {
            throw new IllegalArgumentException("start time must be less than end time");
        }
    }

    private String metricName(String suffix) {
        return MetricRegistry.name((String)"repository", (String[])new String[]{suffix});
    }
}

