/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.persistence.cassandra;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;
import org.opennms.newts.persistence.cassandra.ContextConfiguration;

public class ContextConfigurations {
    private static final Duration DEFAULT_RESOURCE_SHARD = Duration.days((long)7L);
    private final Map<Context, ContextConfiguration> m_contexts = Maps.newHashMap();

    public ContextConfigurations() {
    }

    public ContextConfigurations(Collection<ContextConfiguration> contextConfigs) {
        for (ContextConfiguration contextConfig : contextConfigs) {
            this.addContextConfig(contextConfig);
        }
    }

    public ContextConfigurations addContextConfig(ContextConfiguration contextConfig) {
        this.m_contexts.put(contextConfig.getContext(), contextConfig);
        return this;
    }

    public ContextConfigurations addContextConfig(Context context, Duration resourceShard) {
        return this.addContextConfig(new ContextConfiguration(context, resourceShard));
    }

    public Duration getResourceShard(Context context) {
        ContextConfiguration configConfig = this.m_contexts.get(context);
        if (configConfig != null) {
            return configConfig.getResourceShard();
        }
        return DEFAULT_RESOURCE_SHARD;
    }
}

