/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.FilterAttachable;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AbstractAppenderFactory;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="console")
public class ConsoleAppenderFactory
extends AbstractAppenderFactory {
    @NotNull
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @NotNull
    private ConsoleStream target = ConsoleStream.STDOUT;

    @JsonProperty
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @JsonProperty
    public ConsoleStream getTarget() {
        return this.target;
    }

    @JsonProperty
    public void setTarget(ConsoleStream target) {
        this.target = target;
    }

    @Override
    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, Layout<ILoggingEvent> layout) {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName("console-appender");
        appender.setContext((Context)context);
        appender.setTarget(this.target.get());
        LayoutWrappingEncoder layoutEncoder = new LayoutWrappingEncoder();
        layoutEncoder.setLayout(layout == null ? this.buildLayout(context, this.timeZone) : layout);
        appender.setEncoder((Encoder)layoutEncoder);
        this.addThresholdFilter((FilterAttachable<ILoggingEvent>)appender, this.threshold);
        appender.start();
        return this.wrapAsync((Appender<ILoggingEvent>)appender);
    }

    public static enum ConsoleStream {
        STDOUT("System.out"),
        STDERR("System.err");

        private final String value;

        private ConsoleStream(String value) {
            this.value = value;
        }

        public String get() {
            return this.value;
        }
    }
}

