/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Invoker;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.provider.jffi.AsmLibraryLoader;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BaseMethodGenerator;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.Signature;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import org.objectweb.asm.Label;

abstract class AbstractFastNumericMethodGenerator
extends BaseMethodGenerator {
    private final BufferMethodGenerator bufgen;

    public AbstractFastNumericMethodGenerator(BufferMethodGenerator bufgen) {
        this.bufgen = bufgen;
    }

    public void generate(SkinnyMethodAdapter mv, Signature signature) {
        Label bufferInvocationLabel = AsmLibraryLoader.emitDirectCheck(mv, signature.parameterTypes);
        Class nativeIntType = this.getInvokerType();
        int lvar = 1;
        for (int i = 0; i < signature.parameterTypes.length; ++i) {
            Class parameterType = signature.parameterTypes[i];
            lvar = AsmLibraryLoader.loadParameter(mv, parameterType, lvar);
            if (Float.class == parameterType || Float.TYPE == parameterType) {
                if (!parameterType.isPrimitive()) {
                    AsmUtil.unboxNumber(mv, parameterType, Float.TYPE);
                }
                mv.invokestatic(Float.class, "floatToRawIntBits", Integer.TYPE, Float.TYPE);
                NumberUtil.widen(mv, Integer.TYPE, nativeIntType);
                continue;
            }
            if (Double.class == parameterType || Double.TYPE == parameterType) {
                if (!parameterType.isPrimitive()) {
                    AsmUtil.unboxNumber(mv, parameterType, Double.TYPE);
                }
                mv.invokestatic(Double.class, "doubleToRawLongBits", Long.TYPE, Double.TYPE);
                continue;
            }
            if (parameterType.isPrimitive()) {
                NumberUtil.widen(mv, parameterType, nativeIntType);
                NumberUtil.narrow(mv, parameterType, nativeIntType);
                continue;
            }
            if (Number.class.isAssignableFrom(parameterType)) {
                AsmUtil.unboxNumber(mv, parameterType, nativeIntType);
                continue;
            }
            if (Boolean.class.isAssignableFrom(parameterType)) {
                AsmUtil.unboxBoolean(mv, parameterType, nativeIntType);
                continue;
            }
            if (Pointer.class.isAssignableFrom(parameterType)) {
                AsmUtil.unboxPointer(mv, nativeIntType);
                continue;
            }
            if (Struct.class.isAssignableFrom(parameterType)) {
                AsmUtil.unboxStruct(mv, nativeIntType);
                continue;
            }
            if (Buffer.class.isAssignableFrom(parameterType)) {
                AsmUtil.unboxBuffer(mv, parameterType, nativeIntType);
                continue;
            }
            throw new IllegalArgumentException("unsupported numeric type " + parameterType);
        }
        mv.invokevirtual(CodegenUtils.p(Invoker.class), this.getInvokerMethodName(signature.resultType, signature.resultAnnotations, signature.parameterTypes, signature.parameterAnnotations, signature.ignoreError), this.getInvokerSignature(signature.parameterTypes.length, nativeIntType));
        if (Float.class == signature.resultType || Float.TYPE == signature.resultType) {
            NumberUtil.narrow(mv, nativeIntType, Integer.TYPE);
            mv.invokestatic(Float.class, "intBitsToFloat", Float.TYPE, Integer.TYPE);
        } else if (Double.class == signature.resultType || Double.TYPE == signature.resultType) {
            NumberUtil.widen(mv, nativeIntType, Long.TYPE);
            mv.invokestatic(Double.class, "longBitsToDouble", Double.TYPE, Long.TYPE);
        }
        AsmLibraryLoader.emitReturn(mv, signature.resultType, nativeIntType);
        if (bufferInvocationLabel != null) {
            mv.label(bufferInvocationLabel);
            this.bufgen.generate(mv, signature);
        }
    }

    abstract String getInvokerMethodName(Class var1, Annotation[] var2, Class[] var3, Annotation[][] var4, boolean var5);

    abstract String getInvokerSignature(int var1, Class var2);

    abstract Class getInvokerType();
}

