/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import jnr.ffi.mapper.AbstractDataConverter;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.ToNativeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumMapper
extends AbstractDataConverter<Enum, Integer> {
    private final Class<? extends Enum> enumClass;
    private final Integer[] values;
    private final Map<Integer, Enum> reverseLookupMap = new HashMap<Integer, Enum>();

    private EnumMapper(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
        EnumSet<? extends Enum> enums = EnumSet.allOf(enumClass);
        this.values = new Integer[enums.size()];
        for (Enum enum_ : enums) {
            Integer value;
            this.values[enum_.ordinal()] = value = Integer.valueOf(EnumMapper.getIntegerValue(enum_));
            this.reverseLookupMap.put(value, enum_);
        }
    }

    @Override
    public Enum fromNative(Integer nativeValue, FromNativeContext context) {
        return this.valueOf(nativeValue);
    }

    @Override
    public Class<Integer> nativeType() {
        return Integer.class;
    }

    @Override
    public Integer toNative(Enum value, ToNativeContext context) {
        return this.intValue(this.enumClass.cast(value));
    }

    public static EnumMapper getInstance(Class<? extends Enum> enumClass) {
        EnumMapper mapper = (EnumMapper)StaticDataHolder.MAPPERS.get(enumClass);
        if (mapper != null) {
            return mapper;
        }
        return EnumMapper.addMapper(enumClass);
    }

    private static synchronized EnumMapper addMapper(Class<? extends Enum> enumClass) {
        EnumMapper mapper = new EnumMapper(enumClass);
        IdentityHashMap<Class<? extends Enum>, EnumMapper> tmp = new IdentityHashMap<Class<? extends Enum>, EnumMapper>(StaticDataHolder.MAPPERS);
        tmp.put(enumClass, mapper);
        StaticDataHolder.MAPPERS = tmp;
        return mapper;
    }

    private static final int getIntegerValue(Enum e) {
        if (e instanceof IntegerEnum) {
            return ((IntegerEnum)((Object)e)).intValue();
        }
        return e.ordinal();
    }

    public final int intValue(Enum value) {
        if (value.getClass() != this.enumClass) {
            throw new IllegalArgumentException("enum class mismatch, " + value.getClass());
        }
        return this.values[value.ordinal()];
    }

    public Enum valueOf(int value) {
        return this.valueOf((Integer)value);
    }

    public Enum valueOf(Number value) {
        return this.valueOf((Integer)value.intValue());
    }

    public Enum valueOf(Integer value) {
        Enum e = this.reverseLookupMap.get(value);
        return e != null ? e : this.badValue(value);
    }

    private final Enum badValue(Integer value) {
        try {
            return Enum.valueOf(this.enumClass, "__UNKNOWN_NATIVE_VALUE");
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("No known Enum mapping for value " + value + " of type " + this.enumClass.getName());
        }
    }

    public static interface IntegerEnum {
        public int intValue();
    }

    private static final class StaticDataHolder {
        private static volatile Map<Class<? extends Enum>, EnumMapper> MAPPERS = Collections.emptyMap();

        private StaticDataHolder() {
        }
    }
}

