/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.DateMidnight;
import org.joda.time.ReadableInstant;

public final class DateMidnightSerializer
extends JodaDateSerializerBase<DateMidnight> {
    private static final long serialVersionUID = 1L;

    public DateMidnightSerializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT);
    }

    public DateMidnightSerializer(JacksonJodaDateFormat format) {
        super(DateMidnight.class, format, true, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public DateMidnightSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new DateMidnightSerializer(this._format);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, DateMidnight value) {
        return value.getMillis() == 0L;
    }

    public void serialize(DateMidnight value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value.year().get());
            jgen.writeNumber(value.monthOfYear().get());
            jgen.writeNumber(value.dayOfMonth().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print((ReadableInstant)value));
        }
    }
}

