/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public final class LocalDateTimeSerializer
extends JodaDateSerializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_FORMAT);
    }

    public LocalDateTimeSerializer(JacksonJodaDateFormat format) {
        super(LocalDateTime.class, format, true, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public LocalDateTimeSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new LocalDateTimeSerializer(formatter);
    }

    public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value.year().get());
            jgen.writeNumber(value.monthOfYear().get());
            jgen.writeNumber(value.dayOfMonth().get());
            jgen.writeNumber(value.hourOfDay().get());
            jgen.writeNumber(value.minuteOfHour().get());
            jgen.writeNumber(value.secondOfMinute().get());
            jgen.writeNumber(value.millisOfSecond().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print((ReadablePartial)value));
        }
    }
}

