/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.search.Indexer;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.ContextConfigurations;
import org.opennms.newts.cassandra.search.Constants;
import org.opennms.newts.cassandra.search.ResourceIdSplitter;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;

public class CassandraIndexer
implements Indexer {
    private static final int MAX_BATCH_SIZE = 16;
    private final CassandraSession m_session;
    private final int m_ttl;
    private final ResourceMetadataCache m_cache;
    private final Timer m_updateTimer;
    private final Timer m_deleteTimer;
    private final boolean m_isHierarchicalIndexingEnabled;
    private final ResourceIdSplitter m_resourceIdSplitter;
    private final ContextConfigurations m_contextConfigurations;

    @Inject
    public CassandraIndexer(CassandraSession session, @Named(value="search.cassandra.time-to-live") int ttl, ResourceMetadataCache cache, MetricRegistry registry, @Named(value="search.hierarical-indexing") boolean isHierarchicalIndexingEnabled, ResourceIdSplitter resourceIdSplitter, ContextConfigurations contextConfigurations) {
        this.m_session = (CassandraSession)Preconditions.checkNotNull((Object)session, (Object)"session argument");
        this.m_ttl = ttl;
        this.m_cache = (ResourceMetadataCache)Preconditions.checkNotNull((Object)cache, (Object)"cache argument");
        Preconditions.checkNotNull((Object)registry, (Object)"registry argument");
        this.m_isHierarchicalIndexingEnabled = isHierarchicalIndexingEnabled;
        this.m_resourceIdSplitter = (ResourceIdSplitter)Preconditions.checkNotNull((Object)resourceIdSplitter, (Object)"resourceIdSplitter argument");
        this.m_contextConfigurations = (ContextConfigurations)Preconditions.checkNotNull((Object)contextConfigurations, (Object)"contextConfigurations argument");
        this.m_updateTimer = registry.timer(MetricRegistry.name((String)"search", (String[])new String[]{"update"}));
        this.m_deleteTimer = registry.timer(MetricRegistry.name((String)"search", (String[])new String[]{"delete"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<Sample> samples) {
        Timer.Context ctx = this.m_updateTimer.time();
        ArrayList statements = Lists.newArrayList();
        HashMap cacheQueue = Maps.newHashMap();
        for (Sample sample : samples) {
            ConsistencyLevel writeConsistency = this.m_contextConfigurations.getWriteConsistency(sample.getContext());
            this.maybeIndexResource(cacheQueue, statements, sample.getContext(), sample.getResource(), writeConsistency);
            this.maybeIndexResourceAttributes(cacheQueue, statements, sample.getContext(), sample.getResource(), writeConsistency);
            this.maybeAddMetricName(cacheQueue, statements, sample.getContext(), sample.getResource(), sample.getName(), writeConsistency);
        }
        try {
            if (!statements.isEmpty()) {
                TreeMap<String, RegularStatement> cqlToStatementMap = new TreeMap<String, RegularStatement>();
                for (RegularStatement statement : statements) {
                    cqlToStatementMap.put(statement.toString(), statement);
                }
                statements = Lists.newArrayList(cqlToStatementMap.values());
                ArrayList arrayList = Lists.newArrayList();
                for (List partition : Lists.partition((List)statements, (int)16)) {
                    arrayList.add(this.m_session.executeAsync((Statement)QueryBuilder.batch((RegularStatement[])partition.toArray(new RegularStatement[partition.size()]))));
                }
                for (ResultSetFuture future : arrayList) {
                    future.getUninterruptibly();
                }
            }
            for (Context context : cacheQueue.keySet()) {
                for (Map.Entry entry : ((Map)cacheQueue.get(context)).entrySet()) {
                    this.m_cache.merge(context, (Resource)entry.getKey(), (ResourceMetadata)entry.getValue());
                }
            }
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Context context, Resource resource) {
        Timer.Context ctx = this.m_deleteTimer.time();
        ConsistencyLevel writeConsistency = this.m_contextConfigurations.getWriteConsistency(context);
        ArrayList statements = Lists.newArrayList();
        this.definitelyUnindexResource(statements, context, resource, writeConsistency);
        this.definitelyUnindexResourceAttributes(statements, context, resource, writeConsistency);
        this.definitelyRemoveMetricName(statements, context, resource, writeConsistency);
        try {
            if (!statements.isEmpty()) {
                this.m_session.execute((Statement)QueryBuilder.batch((RegularStatement[])statements.toArray(new RegularStatement[statements.size()])));
            }
            this.m_cache.delete(context, resource);
        }
        finally {
            ctx.stop();
        }
    }

    private void recursivelyIndexResourceElements(List<RegularStatement> statement, Context context, String resourceId, ConsistencyLevel writeConsistencyLevel) {
        List<String> elements = this.m_resourceIdSplitter.splitIdIntoElements(resourceId);
        int numElements = elements.size();
        if (numElements == 1) {
            Insert.Options insert = QueryBuilder.insertInto((String)"terms").value("context", (Object)context.getId()).value("field", (Object)"_parent").value("value", (Object)"_root").value("resource", (Object)resourceId).using(QueryBuilder.ttl((int)this.m_ttl));
            insert.setConsistencyLevel(writeConsistencyLevel);
            statement.add((RegularStatement)insert);
        } else {
            String parentResourceId = this.m_resourceIdSplitter.joinElementsToId(elements.subList(0, numElements - 1));
            Insert.Options insert = QueryBuilder.insertInto((String)"terms").value("context", (Object)context.getId()).value("field", (Object)"_parent").value("value", (Object)parentResourceId).value("resource", (Object)resourceId).using(QueryBuilder.ttl((int)this.m_ttl));
            insert.setConsistencyLevel(writeConsistencyLevel);
            statement.add((RegularStatement)insert);
            this.recursivelyIndexResourceElements(statement, context, parentResourceId, writeConsistencyLevel);
        }
    }

    private void maybeIndexResource(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, List<RegularStatement> statement, Context context, Resource resource, ConsistencyLevel writeConsistencyLevel) {
        if (!this.m_cache.get(context, resource).isPresent()) {
            for (String s : this.m_resourceIdSplitter.splitIdIntoElements(resource.getId())) {
                Insert.Options insert = QueryBuilder.insertInto((String)"terms").value("context", (Object)context.getId()).value("field", (Object)Constants.DEFAULT_TERM_FIELD).value("value", (Object)s).value("resource", (Object)resource.getId()).using(QueryBuilder.ttl((int)this.m_ttl));
                insert.setConsistencyLevel(writeConsistencyLevel);
                statement.add((RegularStatement)insert);
            }
            if (this.m_isHierarchicalIndexingEnabled) {
                this.recursivelyIndexResourceElements(statement, context, resource.getId(), writeConsistencyLevel);
            }
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue);
        }
    }

    private void recursivelyUnindexResourceElements(List<RegularStatement> statement, Context context, String resourceId, ConsistencyLevel writeConsistencyLevel) {
        List<String> elements = this.m_resourceIdSplitter.splitIdIntoElements(resourceId);
        int numElements = elements.size();
        if (numElements == 1) {
            Delete.Where delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", (Object)"_parent")).and(QueryBuilder.eq((String)"value", (Object)"_root")).and(QueryBuilder.eq((String)"resource", (Object)resourceId));
            delete.setConsistencyLevel(writeConsistencyLevel);
            statement.add((RegularStatement)delete);
        } else {
            String parentResourceId = this.m_resourceIdSplitter.joinElementsToId(elements.subList(0, numElements - 1));
            Delete.Where delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", (Object)"_parent")).and(QueryBuilder.eq((String)"value", (Object)parentResourceId)).and(QueryBuilder.eq((String)"resource", (Object)resourceId));
            delete.setConsistencyLevel(writeConsistencyLevel);
            statement.add((RegularStatement)delete);
            this.recursivelyUnindexResourceElements(statement, context, parentResourceId, writeConsistencyLevel);
        }
    }

    private void definitelyUnindexResource(List<RegularStatement> statement, Context context, Resource resource, ConsistencyLevel writeConsistencyLevel) {
        for (String s : this.m_resourceIdSplitter.splitIdIntoElements(resource.getId())) {
            Delete.Where delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", (Object)Constants.DEFAULT_TERM_FIELD)).and(QueryBuilder.eq((String)"value", (Object)s)).and(QueryBuilder.eq((String)"resource", (Object)resource.getId()));
            delete.setConsistencyLevel(writeConsistencyLevel);
            statement.add((RegularStatement)delete);
        }
        if (this.m_isHierarchicalIndexingEnabled) {
            this.recursivelyUnindexResourceElements(statement, context, resource.getId(), writeConsistencyLevel);
        }
    }

    private void maybeIndexResourceAttributes(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, List<RegularStatement> statement, Context context, Resource resource, ConsistencyLevel writeConsistency) {
        if (!resource.getAttributes().isPresent()) {
            return;
        }
        Optional<ResourceMetadata> cached = this.m_cache.get(context, resource);
        for (Map.Entry field : ((Map)resource.getAttributes().get()).entrySet()) {
            if (cached.isPresent() && ((ResourceMetadata)cached.get()).containsAttribute((String)field.getKey(), (String)field.getValue())) continue;
            Insert.Options insert = QueryBuilder.insertInto((String)"terms").value("context", (Object)context.getId()).value("field", (Object)Constants.DEFAULT_TERM_FIELD).value("value", field.getValue()).value("resource", (Object)resource.getId()).using(QueryBuilder.ttl((int)this.m_ttl));
            insert.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)insert);
            insert = QueryBuilder.insertInto((String)"terms").value("context", (Object)context.getId()).value("field", field.getKey()).value("value", field.getValue()).value("resource", (Object)resource.getId()).using(QueryBuilder.ttl((int)this.m_ttl));
            insert.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)insert);
            insert = QueryBuilder.insertInto((String)"resource_attributes").value("context", (Object)context.getId()).value("resource", (Object)resource.getId()).value("attribute", field.getKey()).value("value", field.getValue()).using(QueryBuilder.ttl((int)this.m_ttl));
            insert.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)insert);
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue).putAttribute((String)field.getKey(), (String)field.getValue());
        }
    }

    private void definitelyUnindexResourceAttributes(List<RegularStatement> statement, Context context, Resource resource, ConsistencyLevel writeConsistency) {
        if (!resource.getAttributes().isPresent()) {
            return;
        }
        for (Map.Entry field : ((Map)resource.getAttributes().get()).entrySet()) {
            Delete.Where delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", (Object)Constants.DEFAULT_TERM_FIELD)).and(QueryBuilder.eq((String)"value", field.getValue())).and(QueryBuilder.eq((String)"resource", (Object)resource.getId()));
            delete.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)delete);
            delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", field.getKey())).and(QueryBuilder.eq((String)"value", field.getValue())).and(QueryBuilder.eq((String)"resource", (Object)resource.getId()));
            delete.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)delete);
            delete = QueryBuilder.delete().from("resource_attributes").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"resource", (Object)resource.getId())).and(QueryBuilder.eq((String)"attribute", field.getKey()));
            delete.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)delete);
        }
    }

    private void maybeAddMetricName(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, List<RegularStatement> statement, Context context, Resource resource, String name, ConsistencyLevel writeConsistency) {
        Optional<ResourceMetadata> cached = this.m_cache.get(context, resource);
        if (!cached.isPresent() || !((ResourceMetadata)cached.get()).containsMetric(name)) {
            Insert.Options insert = QueryBuilder.insertInto((String)"resource_metrics").value("context", (Object)context.getId()).value("resource", (Object)resource.getId()).value("metric_name", (Object)name).using(QueryBuilder.ttl((int)this.m_ttl));
            insert.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)insert);
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue).putMetric(name);
        }
    }

    private void definitelyRemoveMetricName(List<RegularStatement> statement, Context context, Resource resource, ConsistencyLevel writeConsistency) {
        Delete.Where delete = QueryBuilder.delete().from("resource_metrics").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"resource", (Object)resource.getId()));
        delete.setConsistencyLevel(writeConsistency);
        statement.add((RegularStatement)delete);
    }

    private static ResourceMetadata getOrCreateResourceMetadata(Context context, Resource resource, Map<Context, Map<Resource, ResourceMetadata>> map) {
        ResourceMetadata rMeta;
        HashMap inner = map.get(context);
        if (inner == null) {
            inner = Maps.newHashMap();
            map.put(context, inner);
        }
        if ((rMeta = (ResourceMetadata)inner.get(resource)) == null) {
            rMeta = new ResourceMetadata();
            inner.put(resource, rMeta);
        }
        return rMeta;
    }
}

