/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jersey2;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.lang.reflect.Method;
import javax.ws.rs.ext.Provider;
import jersey.repackaged.com.google.common.collect.ImmutableMap;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@Provider
public class InstrumentedResourceMethodApplicationListener
implements ApplicationEventListener {
    private final MetricRegistry metrics;
    private ImmutableMap<Method, Timer> timers = ImmutableMap.of();
    private ImmutableMap<Method, Meter> meters = ImmutableMap.of();
    private ImmutableMap<Method, ExceptionMeterMetric> exceptionMeters = ImmutableMap.of();

    public InstrumentedResourceMethodApplicationListener(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void onEvent(ApplicationEvent event) {
        if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
            ImmutableMap.Builder timerBuilder = ImmutableMap.builder();
            ImmutableMap.Builder meterBuilder = ImmutableMap.builder();
            ImmutableMap.Builder exceptionMeterBuilder = ImmutableMap.builder();
            for (Resource resource : event.getResourceModel().getResources()) {
                for (ResourceMethod method : resource.getAllMethods()) {
                    this.registerTimedAnnotations((ImmutableMap.Builder<Method, Timer>)timerBuilder, method);
                    this.registerMeteredAnnotations((ImmutableMap.Builder<Method, Meter>)meterBuilder, method);
                    this.registerExceptionMeteredAnnotations((ImmutableMap.Builder<Method, ExceptionMeterMetric>)exceptionMeterBuilder, method);
                }
                for (Resource childResource : resource.getChildResources()) {
                    for (ResourceMethod method : childResource.getAllMethods()) {
                        this.registerTimedAnnotations((ImmutableMap.Builder<Method, Timer>)timerBuilder, method);
                        this.registerMeteredAnnotations((ImmutableMap.Builder<Method, Meter>)meterBuilder, method);
                        this.registerExceptionMeteredAnnotations((ImmutableMap.Builder<Method, ExceptionMeterMetric>)exceptionMeterBuilder, method);
                    }
                }
            }
            this.timers = timerBuilder.build();
            this.meters = meterBuilder.build();
            this.exceptionMeters = exceptionMeterBuilder.build();
        }
    }

    public RequestEventListener onRequest(RequestEvent event) {
        ChainedRequestEventListener listener = new ChainedRequestEventListener(new RequestEventListener[]{new TimerRequestEventListener(this.timers), new MeterRequestEventListener(this.meters), new ExceptionMeterRequestEventListener(this.exceptionMeters)});
        return listener;
    }

    private void registerTimedAnnotations(ImmutableMap.Builder<Method, Timer> builder, ResourceMethod method) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        Timed annotation = definitionMethod.getAnnotation(Timed.class);
        if (annotation != null) {
            builder.put((Object)definitionMethod, (Object)InstrumentedResourceMethodApplicationListener.timerMetric(this.metrics, method, annotation));
        }
    }

    private void registerMeteredAnnotations(ImmutableMap.Builder<Method, Meter> builder, ResourceMethod method) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        Metered annotation = definitionMethod.getAnnotation(Metered.class);
        if (annotation != null) {
            builder.put((Object)definitionMethod, (Object)InstrumentedResourceMethodApplicationListener.meterMetric(this.metrics, method, annotation));
        }
    }

    private void registerExceptionMeteredAnnotations(ImmutableMap.Builder<Method, ExceptionMeterMetric> builder, ResourceMethod method) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        ExceptionMetered annotation = definitionMethod.getAnnotation(ExceptionMetered.class);
        if (annotation != null) {
            builder.put((Object)definitionMethod, (Object)new ExceptionMeterMetric(this.metrics, method, annotation));
        }
    }

    private static Timer timerMetric(MetricRegistry registry, ResourceMethod method, Timed timed) {
        String name = InstrumentedResourceMethodApplicationListener.chooseName(timed.name(), timed.absolute(), method, new String[0]);
        return registry.timer(name);
    }

    private static Meter meterMetric(MetricRegistry registry, ResourceMethod method, Metered metered) {
        String name = InstrumentedResourceMethodApplicationListener.chooseName(metered.name(), metered.absolute(), method, new String[0]);
        return registry.meter(name);
    }

    protected static String chooseName(String explicitName, boolean absolute, ResourceMethod method, String ... suffixes) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricRegistry.name(method.getInvocable().getDefinitionMethod().getDeclaringClass(), (String[])new String[]{explicitName});
        }
        return MetricRegistry.name((String)MetricRegistry.name(method.getInvocable().getDefinitionMethod().getDeclaringClass(), (String[])new String[]{method.getInvocable().getDefinitionMethod().getName()}), (String[])suffixes);
    }

    private static class ChainedRequestEventListener
    implements RequestEventListener {
        private final RequestEventListener[] listeners;

        private ChainedRequestEventListener(RequestEventListener ... listeners) {
            this.listeners = listeners;
        }

        public void onEvent(RequestEvent event) {
            for (RequestEventListener listener : this.listeners) {
                listener.onEvent(event);
            }
        }
    }

    private static class ExceptionMeterRequestEventListener
    implements RequestEventListener {
        private final ImmutableMap<Method, ExceptionMeterMetric> exceptionMeters;

        public ExceptionMeterRequestEventListener(ImmutableMap<Method, ExceptionMeterMetric> exceptionMeters) {
            this.exceptionMeters = exceptionMeters;
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.ON_EXCEPTION) {
                ExceptionMeterMetric metric;
                ResourceMethod method = event.getUriInfo().getMatchedResourceMethod();
                ExceptionMeterMetric exceptionMeterMetric = metric = method != null ? (ExceptionMeterMetric)this.exceptionMeters.get((Object)method.getInvocable().getDefinitionMethod()) : null;
                if (metric != null && (metric.cause.isAssignableFrom(event.getException().getClass()) || event.getException().getCause() != null && metric.cause.isAssignableFrom(event.getException().getCause().getClass()))) {
                    metric.meter.mark();
                }
            }
        }
    }

    private static class MeterRequestEventListener
    implements RequestEventListener {
        private final ImmutableMap<Method, Meter> meters;

        public MeterRequestEventListener(ImmutableMap<Method, Meter> meters) {
            this.meters = meters;
        }

        public void onEvent(RequestEvent event) {
            Meter meter;
            if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_START && (meter = (Meter)this.meters.get((Object)event.getUriInfo().getMatchedResourceMethod().getInvocable().getDefinitionMethod())) != null) {
                meter.mark();
            }
        }
    }

    private static class TimerRequestEventListener
    implements RequestEventListener {
        private final ImmutableMap<Method, Timer> timers;
        private Timer.Context context = null;

        public TimerRequestEventListener(ImmutableMap<Method, Timer> timers) {
            this.timers = timers;
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_START) {
                Timer timer = (Timer)this.timers.get((Object)event.getUriInfo().getMatchedResourceMethod().getInvocable().getDefinitionMethod());
                if (timer != null) {
                    this.context = timer.time();
                }
            } else if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_FINISHED && this.context != null) {
                this.context.close();
            }
        }
    }

    private static class ExceptionMeterMetric {
        public final Meter meter;
        public final Class<? extends Throwable> cause;

        public ExceptionMeterMetric(MetricRegistry registry, ResourceMethod method, ExceptionMetered exceptionMetered) {
            String name = InstrumentedResourceMethodApplicationListener.chooseName(exceptionMetered.name(), exceptionMetered.absolute(), method, "exceptions");
            this.meter = registry.meter(name);
            this.cause = exceptionMetered.cause();
        }
    }
}

