/*
 * Decompiled with CFR 0.152.
 */
package org.skife.gressil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jnr.ffi.Library;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.byref.IntByReference;
import org.skife.gressil.DaemonCommand;
import org.skife.gressil.DaemonStatus;
import org.skife.gressil.JvmBasedArgvFinder;
import org.skife.gressil.LinuxArgvFinder;
import org.skife.gressil.MicroC;
import org.skife.gressil.Status;

public class Daemon {
    private final List<String> programArgs;
    private final File pidfile;
    private final File out;
    private final File err;
    private final List<String> extraVmArgs;
    private final List<String> extraProgramArgs;
    private static final MicroC posix = (MicroC)Library.loadLibrary((String)"c", MicroC.class);

    public Daemon() {
        this(null, null, new File("/dev/null"), new File("/dev/null"), Collections.emptyList(), Collections.emptyList());
    }

    private Daemon(List<String> argv, File pidfile, File out, File err, List<String> extraVmArgs, List<String> extraProgramArgs) {
        this.programArgs = argv;
        this.pidfile = pidfile;
        this.out = out;
        this.err = err;
        this.extraVmArgs = extraVmArgs;
        this.extraProgramArgs = extraProgramArgs;
    }

    public Daemon withMainArgs(String ... args) {
        return this.withArgv(Arrays.asList(args));
    }

    public Daemon withArgv(List<String> args) {
        return new Daemon(args, this.pidfile, this.out, this.err, this.extraVmArgs, this.extraProgramArgs);
    }

    public Daemon withExtraJvmArgs(List<String> extraVmArgs) {
        return new Daemon(this.programArgs, this.pidfile, this.out, this.err, extraVmArgs, this.extraProgramArgs);
    }

    public Daemon withExtraJvmArgs(String ... extraVmArgs) {
        return new Daemon(this.programArgs, this.pidfile, this.out, this.err, Arrays.asList(extraVmArgs), this.extraProgramArgs);
    }

    public Daemon withExtraMainArgs(List<String> extraProgramArgs) {
        return new Daemon(this.programArgs, this.pidfile, this.out, this.err, this.extraVmArgs, extraProgramArgs);
    }

    public Daemon withExtraMainArgs(String ... extraProgramArgs) {
        return new Daemon(this.programArgs, this.pidfile, this.out, this.err, this.extraVmArgs, Arrays.asList(extraProgramArgs));
    }

    public Daemon withPidFile(File pidfile) {
        return new Daemon(this.programArgs, pidfile, this.out, this.err, this.extraVmArgs, this.extraProgramArgs);
    }

    public Daemon withStdout(File out) {
        return new Daemon(this.programArgs, this.pidfile, out, this.err, this.extraVmArgs, this.extraProgramArgs);
    }

    public Daemon withStderr(File err) {
        return new Daemon(this.programArgs, this.pidfile, this.out, err, this.extraVmArgs, this.extraProgramArgs);
    }

    Status forkish() throws IOException {
        if (Daemon.isDaemon()) {
            posix.setsid();
            PrintStream old_out = System.out;
            PrintStream old_err = System.err;
            System.setOut(new PrintStream(new FileOutputStream(this.out, true)));
            System.setErr(new PrintStream(new FileOutputStream(this.err, true)));
            ((OutputStream)old_err).close();
            ((OutputStream)old_out).close();
            if (this.pidfile != null) {
                FileOutputStream p_out = new FileOutputStream(this.pidfile);
                p_out.write(String.valueOf(posix.getpid()).getBytes());
                p_out.close();
                this.pidfile.deleteOnExit();
            }
            return Status.child(posix.getpid());
        }
        CharSequence[] envp = Daemon.getEnv(Daemon.class.getName() + "=daemon");
        List<String> argv = this.buildARGV(posix);
        Runtime runtime = Runtime.getSystemRuntime();
        Pointer NULL = Pointer.wrap((Runtime)runtime, (long)0L);
        IntByReference child_pid = new IntByReference();
        int rs = posix.posix_spawnp(child_pid, argv.get(0), NULL, NULL, argv.toArray(new String[argv.size()]), envp);
        if (rs != 0) {
            throw new RuntimeException(posix.strerror(rs));
        }
        return Status.parent((Integer)child_pid.getValue());
    }

    public void daemonize() throws IOException {
        if (this.forkish().isParent()) {
            System.exit(0);
        }
    }

    public static boolean isDaemon() {
        return "daemon".equals(System.getenv(Daemon.class.getName()));
    }

    public List<String> buildARGV(MicroC posix) {
        String os = System.getProperty("os.name");
        List<String> argv = this.programArgs != null ? new JvmBasedArgvFinder(this.programArgs).getArgv() : ("Linux".equals(os) ? new LinuxArgvFinder(posix.getpid()).getArgv() : new JvmBasedArgvFinder(this.programArgs).getArgv());
        if (this.extraVmArgs.size() > 0) {
            ArrayList<String> new_argv = new ArrayList<String>(argv.size() + this.extraVmArgs.size());
            new_argv.add(argv.get(0));
            new_argv.addAll(this.extraVmArgs);
            new_argv.addAll(argv.subList(1, argv.size()));
            argv = new_argv;
        }
        if (this.extraProgramArgs.size() > 0) {
            argv.addAll(this.extraProgramArgs);
        }
        return argv;
    }

    public static List<String> waitForRemoteDebugOnPort(int port) {
        return Arrays.asList("-Xdebug", String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=%d", port));
    }

    public static List<String> remoteDebugOnPort(int port) {
        return Arrays.asList("-Xdebug", String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=%d", port));
    }

    public static String[] getEnv(String ... additions) {
        String[] envp = new String[System.getenv().size() + additions.length];
        int i = 0;
        for (Map.Entry<String, String> pair : System.getenv().entrySet()) {
            envp[i++] = pair.getKey() + "=" + pair.getValue();
        }
        System.arraycopy(additions, 0, envp, envp.length - 1, additions.length);
        return envp;
    }

    public DaemonStatus checkStatus() {
        int pid;
        if (this.pidfile == null) {
            throw new IllegalStateException("No pidfile specified, cannot check status!");
        }
        if (!this.pidfile.exists()) {
            return DaemonStatus.STATUS_NOT_RUNNING;
        }
        try {
            byte[] content = Files.readAllBytes(this.pidfile.toPath());
            String s = new String(content, StandardCharsets.UTF_8).trim();
            pid = Integer.parseInt(s);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return DaemonStatus.STATUS_UNKNOWN;
        }
        int rs = posix.kill(pid, 0);
        if (rs == 0) {
            return DaemonStatus.STATUS_RUNNING;
        }
        return DaemonStatus.STATUS_DEAD;
    }

    public DaemonStatus stop() {
        int pid;
        if (this.pidfile == null) {
            throw new IllegalStateException("No pidfile specified, cannot stop!");
        }
        if (!this.pidfile.exists()) {
            return DaemonStatus.STOP_NOT_RUNNING;
        }
        try {
            byte[] content = Files.readAllBytes(this.pidfile.toPath());
            String s = new String(content, StandardCharsets.UTF_8).trim();
            pid = Integer.parseInt(s);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return DaemonStatus.STOP_GENERAL_ERROR;
        }
        int rs = posix.kill(pid, 2);
        if (rs == 0) {
            return DaemonStatus.STOP_SUCCESS;
        }
        return DaemonStatus.STOP_GENERAL_ERROR;
    }

    public void execute(DaemonCommand cmd) throws IOException {
        switch (cmd) {
            case start: {
                this.daemonize();
                break;
            }
            case status: {
                DaemonStatus status = this.checkStatus();
                System.exit(status.getExitCode());
                break;
            }
            case stop: {
                DaemonStatus status = this.stop();
                System.exit(status.getExitCode());
            }
        }
    }
}

