/*
 * Decompiled with CFR 0.152.
 */
package org.skife.gressil;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.skife.gressil.ArgvFinder;

class JvmBasedArgvFinder
implements ArgvFinder {
    private final List<String> programArgs;

    public JvmBasedArgvFinder(List<String> programArgs) {
        this.programArgs = programArgs;
    }

    @Override
    public List<String> getArgv() {
        ArrayList<String> ARGV = new ArrayList<String>();
        String java = System.getProperty("java.home") + "/bin/java";
        ARGV.add(java);
        List<String> raw_jvm_args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        ArrayList<String> fixed_jvm_args = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (String raw_arg : raw_jvm_args) {
            if (raw_arg.startsWith("-")) {
                if (current.length() > 0) {
                    fixed_jvm_args.add(current.toString());
                    current = new StringBuilder();
                }
                current.append(raw_arg);
                continue;
            }
            current.append("\\ ").append(raw_arg);
        }
        ARGV.addAll(fixed_jvm_args);
        String whole_command_line = System.getProperty("sun.java.command");
        String[] java_sun_command = whole_command_line.split("\\s+");
        String cmd = java_sun_command[0];
        if (new File(cmd).exists()) {
            ARGV.add("-jar");
            ARGV.add(new File(java_sun_command[0]).getPath());
        } else {
            ARGV.add("-cp");
            String raw_cp = System.getProperty("java.class.path").replaceAll(" ", "\\ ");
            ARGV.add(raw_cp);
            ARGV.add(cmd);
        }
        if (this.programArgs == null) {
            ARGV.addAll(Arrays.asList(java_sun_command).subList(1, java_sun_command.length));
        } else {
            ARGV.addAll(this.programArgs);
        }
        return ARGV;
    }
}

