/*
 * Decompiled with CFR 0.152.
 */
package org.skife.gressil;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import jnr.ffi.Library;
import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.byref.IntByReference;
import org.skife.gressil.ArgvFinder;

class MacARGVFinder
implements ArgvFinder {
    MacARGVFinder() {
    }

    @Override
    public List<String> getArgv() {
        boolean CTL_KERN = true;
        int KERN_PROCARGS2 = 49;
        Runtime runtime = Runtime.getSystemRuntime();
        Pointer NULL = Pointer.wrap((Runtime)runtime, (long)0L);
        SmallC sc = (SmallC)Library.loadLibrary((String)"c", SmallC.class);
        final IntByReference oldlenp = new IntByReference(4);
        int rs = sc.sysctl(new int[]{1, 49, sc.getpid()}, 3, NULL, oldlenp, NULL, 0);
        if (rs != 0) {
            throw new IllegalStateException(sc.strerror(rs));
        }
        final Pointer oldp = Memory.allocateDirect((Runtime)runtime, (int)((Integer)oldlenp.getValue()));
        rs = sc.sysctl(new int[]{1, 49, sc.getpid()}, 3, oldp, oldlenp, NULL, 0);
        if (rs != 0) {
            throw new IllegalStateException(sc.strerror(rs));
        }
        class ProcessStuffReader {
            private int offset = 0;
            private final int argc;
            private final int size = (Integer)oldlenp.getValue();
            private final List<String> argv;

            ProcessStuffReader() {
                this.argc = this.readInt();
                this.readString();
                this.skipNulls();
                ArrayList<String> argv = new ArrayList<String>(this.argc);
                for (int i = 0; i < this.argc; ++i) {
                    argv.add(this.readString());
                }
                this.argv = argv;
            }

            private int readInt() {
                int i = oldp.getInt((long)this.offset);
                this.offset += 4;
                return i;
            }

            private void skipNulls() {
                while (this.offset < this.size && oldp.getByte((long)this.offset) == 0) {
                    ++this.offset;
                }
            }

            private String readString() {
                byte c;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((c = oldp.getByte((long)this.offset++)) != 0) {
                    bout.write(c);
                }
                return new String(bout.toByteArray());
            }

            public List<String> getArgv() {
                return this.argv;
            }
        }
        return new ProcessStuffReader().getArgv();
    }

    public static interface SmallC {
        public int sysctl(int[] var1, int var2, Pointer var3, IntByReference var4, Pointer var5, int var6);

        public int getpid();

        public String strerror(int var1);
    }
}

