/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.cassandra.CassandraException;
import org.opennms.newts.cassandra.CassandraSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSessionImpl
implements CassandraSession {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSessionImpl.class);
    private final Session m_session;

    @Inject
    public CassandraSessionImpl(@Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.hostname") String hostname, @Named(value="cassandra.port") int port, @Named(value="cassandra.compression") String compression, @Named(value="cassandra.username") String username, @Named(value="cassandra.password") String password, @Named(value="cassandra.ssl") boolean ssl) {
        Preconditions.checkNotNull((Object)keyspace, (Object)"keyspace argument");
        Preconditions.checkNotNull((Object)hostname, (Object)"hostname argument");
        Preconditions.checkArgument((port > 0 && port < 65535 ? 1 : 0) != 0, (String)"not a valid port number: %d", (Object[])new Object[]{port});
        Preconditions.checkNotNull((Object)compression, (Object)"compression argument");
        LOG.info("Setting up session with {}:{} using compression {}", new Object[]{hostname, port, compression.toUpperCase()});
        Cluster.Builder builder = Cluster.builder().withPort(port).addContactPoints(hostname.split(",")).withCompression(ProtocolOptions.Compression.valueOf((String)compression.toUpperCase()));
        if (username != null && password != null) {
            LOG.info("Using username: {} and password: XXXXXXXX", (Object)username);
            builder.withCredentials(username, password);
        }
        if (ssl) {
            LOG.info("Enabling SSL.");
            builder.withSSL();
        }
        this.m_session = builder.build().connect(keyspace);
    }

    @Override
    public PreparedStatement prepare(String statement) {
        try {
            return this.m_session.prepare(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public PreparedStatement prepare(RegularStatement statement) {
        try {
            return this.m_session.prepare(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public ResultSetFuture executeAsync(Statement statement) {
        try {
            return this.m_session.executeAsync(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public ResultSet execute(Statement statement) {
        try {
            return this.m_session.execute(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public ResultSet execute(String statement) {
        try {
            return this.m_session.execute(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    @Override
    public Future<Void> shutdown() {
        final CloseFuture future = this.m_session.closeAsync();
        return new Future<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                return (Void)future.get();
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return (Void)future.get(timeout, unit);
            }
        };
    }
}

