/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Preconditions;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;

public class ContextConfiguration {
    private final Context m_context;
    private final Duration m_resourceShard;
    private final ConsistencyLevel m_readConsistency;
    private final ConsistencyLevel m_writeConsistency;

    public ContextConfiguration(Context context, Duration resourceShard, ConsistencyLevel readConsistency, ConsistencyLevel writeConsistency) {
        this.m_context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context argument");
        this.m_resourceShard = (Duration)Preconditions.checkNotNull((Object)resourceShard, (Object)"resourceShard argument");
        this.m_readConsistency = (ConsistencyLevel)Preconditions.checkNotNull((Object)readConsistency, (Object)"readConsistency argument");
        this.m_writeConsistency = (ConsistencyLevel)Preconditions.checkNotNull((Object)writeConsistency, (Object)"writeConsistency argument");
    }

    public Context getContext() {
        return this.m_context;
    }

    public Duration getResourceShard() {
        return this.m_resourceShard;
    }

    public ConsistencyLevel getReadConsistency() {
        return this.m_readConsistency;
    }

    public ConsistencyLevel getWriteConsistency() {
        return this.m_writeConsistency;
    }
}

