/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;
import org.opennms.newts.cassandra.ContextConfiguration;

public class ContextConfigurations {
    private static final Duration DEFAULT_RESOURCE_SHARD = Duration.days((long)7L);
    private static final ConsistencyLevel DEFAULT_READ_CONSISTENCY = ConsistencyLevel.ONE;
    private static final ConsistencyLevel DEFAULT_WRITE_CONSISTENCY = ConsistencyLevel.ANY;
    private final Map<Context, ContextConfiguration> m_contexts = Maps.newHashMap();

    public ContextConfigurations() {
    }

    public ContextConfigurations(Collection<ContextConfiguration> contextConfigs) {
        for (ContextConfiguration contextConfig : contextConfigs) {
            this.addContextConfig(contextConfig);
        }
    }

    public ContextConfigurations addContextConfig(ContextConfiguration contextConfig) {
        this.m_contexts.put(contextConfig.getContext(), contextConfig);
        return this;
    }

    public ContextConfigurations addContextConfig(Context context, Duration resourceShard, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel) {
        this.m_contexts.put(context, new ContextConfiguration(context, resourceShard, readConsistencyLevel, writeConsistencyLevel));
        return this;
    }

    public Duration getResourceShard(Context context) {
        ContextConfiguration configConfig = this.m_contexts.get(context);
        if (configConfig != null) {
            return configConfig.getResourceShard();
        }
        return DEFAULT_RESOURCE_SHARD;
    }

    public ConsistencyLevel getReadConsistency(Context context) {
        ContextConfiguration configConfig = this.m_contexts.get(context);
        if (configConfig != null) {
            return configConfig.getReadConsistency();
        }
        return DEFAULT_READ_CONSISTENCY;
    }

    public ConsistencyLevel getWriteConsistency(Context context) {
        ContextConfiguration configConfig = this.m_contexts.get(context);
        if (configConfig != null) {
            return configConfig.getWriteConsistency();
        }
        return DEFAULT_WRITE_CONSISTENCY;
    }
}

