/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.search.Indexer;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.search.Constants;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;

public class CassandraIndexer
implements Indexer {
    private static Splitter s_pathSplitter = Splitter.on((char)':').omitEmptyStrings().trimResults();
    private final CassandraSession m_session;
    private final int m_ttl;
    private final ResourceMetadataCache m_cache;
    private final Timer m_updateTimer;

    @Inject
    public CassandraIndexer(CassandraSession session, @Named(value="search.cassandra.time-to-live") int ttl, ResourceMetadataCache cache, MetricRegistry registry) {
        this.m_session = (CassandraSession)Preconditions.checkNotNull((Object)session, (Object)"session argument");
        this.m_ttl = ttl;
        this.m_cache = (ResourceMetadataCache)Preconditions.checkNotNull((Object)cache, (Object)"cache argument");
        Preconditions.checkNotNull((Object)registry, (Object)"registry argument");
        this.m_updateTimer = registry.timer(MetricRegistry.name((String)"search", (String[])new String[]{"update"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<Sample> samples) {
        Timer.Context ctx = this.m_updateTimer.time();
        ArrayList statements = Lists.newArrayList();
        HashMap cacheQueue = Maps.newHashMap();
        for (Sample sample : samples) {
            this.maybeIndexResource(cacheQueue, statements, sample.getContext(), sample.getResource());
            this.maybeIndexResourceAttributes(cacheQueue, statements, sample.getContext(), sample.getResource());
            this.maybeAddMetricName(cacheQueue, statements, sample.getContext(), sample.getResource(), sample.getName());
        }
        try {
            if (statements.size() > 0) {
                this.m_session.execute(QueryBuilder.batch((RegularStatement[])statements.toArray(new RegularStatement[0])).toString());
            }
            for (Context context : cacheQueue.keySet()) {
                for (Map.Entry entry : ((Map)cacheQueue.get(context)).entrySet()) {
                    this.m_cache.merge(context, (Resource)entry.getKey(), (ResourceMetadata)entry.getValue());
                }
            }
        }
        finally {
            ctx.stop();
        }
    }

    private void maybeIndexResource(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, List<RegularStatement> statement, Context context, Resource resource) {
        if (!this.m_cache.get(context, resource).isPresent()) {
            for (String s : s_pathSplitter.split((CharSequence)resource.getId())) {
                statement.add((RegularStatement)QueryBuilder.insertInto((String)"terms").value("context", (Object)context.getId()).value("field", (Object)Constants.DEFAULT_TERM_FIELD).value("value", (Object)s).value("resource", (Object)resource.getId()).using(QueryBuilder.ttl((int)this.m_ttl)));
            }
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue);
        }
    }

    private void maybeIndexResourceAttributes(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, List<RegularStatement> statement, Context context, Resource resource) {
        if (!resource.getAttributes().isPresent()) {
            return;
        }
        Optional<ResourceMetadata> cached = this.m_cache.get(context, resource);
        for (Map.Entry field : ((Map)resource.getAttributes().get()).entrySet()) {
            if (cached.isPresent() && ((ResourceMetadata)cached.get()).containsAttribute((String)field.getKey(), (String)field.getValue())) continue;
            statement.add((RegularStatement)QueryBuilder.insertInto((String)"terms").value("context", (Object)context.getId()).value("field", (Object)Constants.DEFAULT_TERM_FIELD).value("value", field.getValue()).value("resource", (Object)resource.getId()).using(QueryBuilder.ttl((int)this.m_ttl)));
            statement.add((RegularStatement)QueryBuilder.insertInto((String)"terms").value("context", (Object)context.getId()).value("field", field.getKey()).value("value", field.getValue()).value("resource", (Object)resource.getId()).using(QueryBuilder.ttl((int)this.m_ttl)));
            statement.add((RegularStatement)QueryBuilder.insertInto((String)"resource_attributes").value("context", (Object)context.getId()).value("resource", (Object)resource.getId()).value("attribute", field.getKey()).value("value", field.getValue()).using(QueryBuilder.ttl((int)this.m_ttl)));
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue).putAttribute((String)field.getKey(), (String)field.getValue());
        }
    }

    private void maybeAddMetricName(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, List<RegularStatement> statement, Context context, Resource resource, String name) {
        Optional<ResourceMetadata> cached = this.m_cache.get(context, resource);
        if (!cached.isPresent() || !((ResourceMetadata)cached.get()).containsMetric(name)) {
            statement.add((RegularStatement)QueryBuilder.insertInto((String)"resource_metrics").value("context", (Object)context.getId()).value("resource", (Object)resource.getId()).value("metric_name", (Object)name).using(QueryBuilder.ttl((int)this.m_ttl)));
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue).putMetric(name);
        }
    }

    private static ResourceMetadata getOrCreateResourceMetadata(Context context, Resource resource, Map<Context, Map<Resource, ResourceMetadata>> map) {
        ResourceMetadata rMeta;
        HashMap inner = map.get(context);
        if (inner == null) {
            inner = Maps.newHashMap();
            map.put(context, inner);
        }
        if ((rMeta = (ResourceMetadata)inner.get(resource)) == null) {
            rMeta = new ResourceMetadata();
            inner.put(resource, rMeta);
        }
        return rMeta;
    }
}

