/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.search.SearchResults;
import org.opennms.newts.api.search.Searcher;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.search.Constants;

public class CassandraSearcher
implements Searcher {
    private static final Splitter s_tokenSplitter = Splitter.onPattern((String)"\\s+").omitEmptyStrings().trimResults();
    private final CassandraSession m_session;
    private final Timer m_searchTimer;

    @Inject
    public CassandraSearcher(CassandraSession session, MetricRegistry registry) {
        this.m_session = (CassandraSession)Preconditions.checkNotNull((Object)session, (Object)"session argument");
        this.m_searchTimer = registry.timer(MetricRegistry.name((String)"search", (String[])new String[]{"search"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResults search(String queryString) {
        Timer.Context ctx = this.m_searchTimer.time();
        SearchResults searchResults = new SearchResults();
        for (String term : s_tokenSplitter.splitToList((CharSequence)queryString)) {
            Term t = Term.parse(term);
            Select.Where searchQuery = QueryBuilder.select((String[])new String[]{"resource"}).from("terms").where(QueryBuilder.eq((String)"context", (Object)Context.DEFAULT_CONTEXT.getId())).and(QueryBuilder.eq((String)"field", (Object)t.getField())).and(QueryBuilder.eq((String)"value", (Object)t.getValue()));
            for (Row row : this.m_session.execute(searchQuery.toString())) {
                String id = row.getString("resource");
                Optional<Map<String, String>> attrs = this.fetchResourceAttributes(Context.DEFAULT_CONTEXT, id);
                Collection<String> metrics = this.fetchMetricNames(Context.DEFAULT_CONTEXT, id);
                searchResults.addResult(new Resource(id, attrs), metrics);
            }
        }
        try {
            SearchResults searchResults2 = searchResults;
            return searchResults2;
        }
        finally {
            ctx.stop();
        }
    }

    private Optional<Map<String, String>> fetchResourceAttributes(Context context, String resourceId) {
        HashMap attributes = Maps.newHashMap();
        Select.Where searchQuery = QueryBuilder.select((String[])new String[]{"attribute", "value"}).from("resource_attributes").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"resource", (Object)resourceId));
        for (Row row : this.m_session.execute(searchQuery.toString())) {
            attributes.put(row.getString("attribute"), row.getString("value"));
        }
        return attributes.size() > 0 ? Optional.of((Object)attributes) : Optional.absent();
    }

    private Collection<String> fetchMetricNames(Context context, String resourceId) {
        ArrayList metricNames = Lists.newArrayList();
        Select.Where select = QueryBuilder.select((String[])new String[]{"metric_name"}).from("resource_metrics").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"resource", (Object)resourceId));
        for (Row row : this.m_session.execute(select.toString())) {
            metricNames.add(row.getString("metric_name"));
        }
        return metricNames;
    }

    static class Term {
        private static Splitter s_splitter = Splitter.on((char)':').limit(2).trimResults().omitEmptyStrings();
        private String m_field;
        private String m_value;

        Term(String field, String value) {
            this.m_field = (String)Preconditions.checkNotNull((Object)field, (Object)"field argument");
            this.m_value = (String)Preconditions.checkNotNull((Object)value, (Object)"value argument");
        }

        String getField() {
            return this.m_field;
        }

        String getValue() {
            return this.m_value;
        }

        static Term parse(String term) {
            List t = s_splitter.splitToList((CharSequence)term);
            String field = t.size() < 2 ? Constants.DEFAULT_TERM_FIELD : (String)t.get(0);
            String value = t.size() < 2 ? (String)t.get(0) : (String)t.get(1);
            return new Term(field, value);
        }
    }
}

