/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;

public class GuavaResourceMetadataCache
implements ResourceMetadataCache {
    private static final Joiner m_keyJoiner = Joiner.on((char)':');
    private final Cache<String, ResourceMetadata> m_cache;
    private final Meter m_metricReqs;
    private final Meter m_attributeReqs;
    private final Meter m_metricMisses;
    private final Meter m_attributeMisses;

    @Inject
    public GuavaResourceMetadataCache(@Named(value="search.rMetadata.maxCacheSize") long maxSize, MetricRegistry registry) {
        this.m_cache = CacheBuilder.newBuilder().maximumSize(maxSize).build();
        this.m_metricReqs = registry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"metric-reqs"}));
        this.m_metricMisses = registry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"metric-misses"}));
        this.m_attributeReqs = registry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"attribute-reqs"}));
        this.m_attributeMisses = registry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"attribute-misses"}));
    }

    @Override
    public Optional<ResourceMetadata> get(Context context, Resource resourceId) {
        ResourceMetadata r = (ResourceMetadata)this.m_cache.getIfPresent((Object)this.key(context, resourceId));
        return r != null ? Optional.of((Object)r) : Optional.absent();
    }

    private String key(Context context, Resource resource) {
        return m_keyJoiner.join((Object)context.getId(), (Object)resource.getId(), new Object[0]);
    }

    @Override
    public void merge(Context context, Resource resource, ResourceMetadata metadata) {
        Optional<ResourceMetadata> o = this.get(context, resource);
        if (!o.isPresent()) {
            ResourceMetadata newMetadata = new ResourceMetadata(this.m_metricReqs, this.m_attributeReqs, this.m_metricMisses, this.m_attributeMisses);
            newMetadata.merge(metadata);
            this.m_cache.put((Object)this.key(context, resource), (Object)newMetadata);
            return;
        }
        ((ResourceMetadata)o.get()).merge(metadata);
    }
}

