/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.codahale.metrics.Meter;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class ResourceMetadata {
    private final Set<String> m_metrics = Sets.newConcurrentHashSet();
    private final Map<String, String> m_attributes = Maps.newConcurrentMap();
    private final Optional<Meter> m_metricReqs;
    private final Optional<Meter> m_attributeReqs;
    private final Optional<Meter> m_metricMisses;
    private final Optional<Meter> m_attributeMisses;

    public ResourceMetadata(Meter metricReqs, Meter attributeReqs, Meter metricMisses, Meter attributeMisses) {
        this.m_metricReqs = Optional.of((Object)Preconditions.checkNotNull((Object)metricReqs, (Object)"metricsReqs argument"));
        this.m_attributeReqs = Optional.of((Object)Preconditions.checkNotNull((Object)attributeReqs, (Object)"attributesReqs argument"));
        this.m_metricMisses = Optional.of((Object)Preconditions.checkNotNull((Object)metricMisses, (Object)"metricsMisses argument"));
        this.m_attributeMisses = Optional.of((Object)Preconditions.checkNotNull((Object)attributeMisses, (Object)"attributesMisses argument"));
    }

    public ResourceMetadata() {
        this.m_metricReqs = Optional.absent();
        this.m_attributeReqs = Optional.absent();
        this.m_metricMisses = Optional.absent();
        this.m_attributeMisses = Optional.absent();
    }

    public boolean containsMetric(String metric) {
        boolean contains;
        if (this.m_metricReqs.isPresent()) {
            ((Meter)this.m_metricReqs.get()).mark();
        }
        if (!(contains = this.m_metrics.contains(metric)) && this.m_metricMisses.isPresent()) {
            ((Meter)this.m_metricMisses.get()).mark();
        }
        return contains;
    }

    public ResourceMetadata putMetric(String metric) {
        this.m_metrics.add(metric);
        return this;
    }

    public boolean containsAttribute(String key, String value) {
        boolean contains;
        if (this.m_attributeReqs.isPresent()) {
            ((Meter)this.m_attributeReqs.get()).mark();
        }
        boolean bl = contains = this.m_attributes.containsKey(key) && this.m_attributes.get(key).equals(value);
        if (!contains && this.m_attributeMisses.isPresent()) {
            ((Meter)this.m_attributeMisses.get()).mark();
        }
        return contains;
    }

    public ResourceMetadata putAttribute(String key, String value) {
        this.m_attributes.put(key, value);
        return this;
    }

    public void merge(ResourceMetadata other) {
        this.m_metrics.addAll(other.m_metrics);
        this.m_attributes.putAll(other.m_attributes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_attributes == null ? 0 : this.m_attributes.hashCode());
        result = 31 * result + (this.m_metrics == null ? 0 : this.m_metrics.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMetadata other = (ResourceMetadata)obj;
        if (this.m_attributes == null ? other.m_attributes != null : !this.m_attributes.equals(other.m_attributes)) {
            return false;
        }
        return !(this.m_metrics == null ? other.m_metrics != null : !this.m_metrics.equals(other.m_metrics));
    }
}

