/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.opennms.newts.cassandra.search.ResourceIdSplitter;

public class EscapableResourceIdSplitter
implements ResourceIdSplitter {
    private static final Pattern MATCH_COLON = Pattern.compile(":");
    private static final Pattern MATCH_BACKSLASH = Pattern.compile("\\\\");
    private static final Pattern MATCH_ESCAPED_COLON = Pattern.compile("\\\\:");
    private static final Pattern MATCH_ESCAPED_BACKSLASH = Pattern.compile("\\\\\\\\");

    @Override
    public List<String> splitIdIntoElements(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id argument");
        ArrayList elements = Lists.newArrayList();
        int startOfNextElement = 0;
        int numConsecutiveEscapeCharacters = 0;
        char[] idChars = id.toCharArray();
        for (int i = 0; i < idChars.length; ++i) {
            if (idChars[i] == ':' && numConsecutiveEscapeCharacters % 2 == 0) {
                EscapableResourceIdSplitter.maybeAddSanitizedElement(new String(idChars, startOfNextElement, i - startOfNextElement), elements);
                startOfNextElement = i + 1;
            }
            if (idChars[i] == '\\') {
                ++numConsecutiveEscapeCharacters;
                continue;
            }
            numConsecutiveEscapeCharacters = 0;
        }
        EscapableResourceIdSplitter.maybeAddSanitizedElement(new String(idChars, startOfNextElement, idChars.length - startOfNextElement), elements);
        return elements;
    }

    private static void maybeAddSanitizedElement(String element, List<String> elements) {
        String sanitizedElement = element.trim();
        if (sanitizedElement.length() == 0) {
            return;
        }
        sanitizedElement = MATCH_ESCAPED_COLON.matcher(sanitizedElement).replaceAll(":");
        sanitizedElement = MATCH_ESCAPED_BACKSLASH.matcher(sanitizedElement).replaceAll("\\\\");
        elements.add(sanitizedElement);
    }

    @Override
    public String joinElementsToId(List<String> elements) {
        Preconditions.checkNotNull(elements, (Object)"elements argument");
        StringBuilder sb = new StringBuilder();
        for (String el : elements) {
            String trimmedEl;
            if (el == null || (trimmedEl = el.trim()).length() < 1) continue;
            trimmedEl = MATCH_BACKSLASH.matcher(trimmedEl).replaceAll("\\\\\\\\");
            trimmedEl = MATCH_COLON.matcher(trimmedEl).replaceAll("\\\\:");
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(trimmedEl);
        }
        return sb.toString();
    }
}

