/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.search.BooleanClause;
import org.opennms.newts.api.search.BooleanQuery;
import org.opennms.newts.api.search.Query;
import org.opennms.newts.api.search.SearchResults;
import org.opennms.newts.api.search.Searcher;
import org.opennms.newts.api.search.TermQuery;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.ContextConfigurations;
import org.opennms.newts.cassandra.search.Constants;

public class CassandraSearcher
implements Searcher {
    private final CassandraSession m_session;
    private final Timer m_searchTimer;
    private final ContextConfigurations m_contextConfigurations;
    private final PreparedStatement m_searchStatement;
    private final PreparedStatement m_selectAttributesStatement;
    private final PreparedStatement m_selectMetricNamesStatement;

    @Inject
    public CassandraSearcher(CassandraSession session, @Named(value="newtsMetricRegistry") MetricRegistry registry, ContextConfigurations contextConfigurations) {
        this.m_session = (CassandraSession)Preconditions.checkNotNull((Object)session, (Object)"session argument");
        this.m_searchTimer = registry.timer(MetricRegistry.name((String)"search", (String[])new String[]{"search"}));
        this.m_contextConfigurations = (ContextConfigurations)Preconditions.checkNotNull((Object)contextConfigurations, (Object)"contextConfigurations argument");
        Select select = QueryBuilder.select((String[])new String[]{"resource"}).from("terms");
        select.where(QueryBuilder.eq((String)"context", (Object)QueryBuilder.bindMarker((String)"context"))).and(QueryBuilder.eq((String)"field", (Object)QueryBuilder.bindMarker((String)"field"))).and(QueryBuilder.eq((String)"value", (Object)QueryBuilder.bindMarker((String)"value")));
        this.m_searchStatement = this.m_session.prepare(select.toString());
        select = QueryBuilder.select((String[])new String[]{"attribute", "value"}).from("resource_attributes");
        select.where(QueryBuilder.eq((String)"context", (Object)QueryBuilder.bindMarker((String)"context"))).and(QueryBuilder.eq((String)"resource", (Object)QueryBuilder.bindMarker((String)"resource")));
        this.m_selectAttributesStatement = this.m_session.prepare(select.toString());
        select = QueryBuilder.select((String[])new String[]{"metric_name"}).from("resource_metrics");
        select.where(QueryBuilder.eq((String)"context", (Object)QueryBuilder.bindMarker((String)"context"))).and(QueryBuilder.eq((String)"resource", (Object)QueryBuilder.bindMarker((String)"resource")));
        this.m_selectMetricNamesStatement = this.m_session.prepare(select.toString());
    }

    public SearchResults search(Context context, Query query) {
        return this.search(context, query, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResults search(Context context, Query query, boolean populateMetricsAndAttributes) {
        Preconditions.checkNotNull((Object)context, (Object)"context argument");
        Preconditions.checkNotNull((Object)query, (Object)"query argument");
        Timer.Context ctx = this.m_searchTimer.time();
        ConsistencyLevel readConsistency = this.m_contextConfigurations.getReadConsistency(context);
        SearchResults searchResults = new SearchResults();
        try {
            Set<String> ids;
            Query q = query.rewrite();
            if (q instanceof BooleanQuery) {
                ids = this.searchForIds(context, (BooleanQuery)q, readConsistency);
            } else if (q instanceof TermQuery) {
                ids = this.searchForIds(context, (TermQuery)q, readConsistency);
            } else {
                throw new IllegalStateException("Unsupported query: " + q);
            }
            for (String id : ids) {
                if (!populateMetricsAndAttributes) {
                    Resource resource = new Resource(id);
                    List emptyList = Collections.emptyList();
                    searchResults.addResult(resource, emptyList);
                    continue;
                }
                ResultSetFuture attrsFuture = this.fetchResourceAttributes(context, id, readConsistency);
                ResultSetFuture metricsFuture = this.fetchMetricNames(context, id, readConsistency);
                try {
                    Map<String, String> attrs = this.getResourceAttributesFromResults(attrsFuture);
                    Collection<String> metrics = this.getMetricNamesFromResults(metricsFuture);
                    Resource resource = attrs.size() > 0 ? new Resource(id, Optional.of(attrs)) : new Resource(id);
                    searchResults.addResult(resource, metrics);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            SearchResults searchResults2 = searchResults;
            return searchResults2;
        }
        finally {
            ctx.stop();
        }
    }

    public Map<String, String> getResourceAttributes(Context context, String resourceId) {
        try {
            ConsistencyLevel readConsistency = this.m_contextConfigurations.getReadConsistency(context);
            return this.getResourceAttributesFromResults(this.fetchResourceAttributes(context, resourceId, readConsistency));
        }
        catch (InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Collection<String> getMetricNames(Context context, String resourceId) {
        try {
            ConsistencyLevel readConsistency = this.m_contextConfigurations.getReadConsistency(context);
            return this.getMetricNamesFromResults(this.fetchMetricNames(context, resourceId, readConsistency));
        }
        catch (InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Set<String> searchForIds(Context context, TermQuery query, ConsistencyLevel readConsistency) {
        TreeSet ids = Sets.newTreeSet();
        BoundStatement bindStatement = this.m_searchStatement.bind();
        bindStatement.setString("context", context.getId());
        bindStatement.setString("field", query.getTerm().getField(Constants.DEFAULT_TERM_FIELD));
        bindStatement.setString("value", query.getTerm().getValue());
        bindStatement.setConsistencyLevel(readConsistency);
        for (Row row : this.m_session.execute((Statement)bindStatement)) {
            ids.add(row.getString("resource"));
        }
        return ids;
    }

    private Set<String> searchForIds(Context context, BooleanQuery query, ConsistencyLevel readConsistency) {
        TreeSet ids = Sets.newTreeSet();
        block4: for (BooleanClause clause : query.getClauses()) {
            Set<String> subQueryIds;
            Query subQuery = clause.getQuery();
            if (subQuery instanceof BooleanQuery) {
                subQueryIds = this.searchForIds(context, (BooleanQuery)subQuery, readConsistency);
            } else if (subQuery instanceof TermQuery) {
                subQueryIds = this.searchForIds(context, (TermQuery)subQuery, readConsistency);
            } else {
                throw new IllegalStateException("Unsupported query: " + subQuery);
            }
            switch (clause.getOperator()) {
                case AND: {
                    ids.retainAll(subQueryIds);
                    continue block4;
                }
                case OR: {
                    ids.addAll(subQueryIds);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unsupported operator: " + clause.getOperator());
        }
        return ids;
    }

    private ResultSetFuture fetchResourceAttributes(Context context, String resourceId, ConsistencyLevel readConsistency) {
        BoundStatement bindStatement = this.m_selectAttributesStatement.bind();
        bindStatement.setString("context", context.getId());
        bindStatement.setString("resource", resourceId);
        bindStatement.setConsistencyLevel(readConsistency);
        return this.m_session.executeAsync((Statement)bindStatement);
    }

    private Map<String, String> getResourceAttributesFromResults(ResultSetFuture results) throws InterruptedException, ExecutionException {
        HashMap attributes = Maps.newHashMap();
        for (Row row : (ResultSet)results.get()) {
            attributes.put(row.getString("attribute"), row.getString("value"));
        }
        return attributes;
    }

    private ResultSetFuture fetchMetricNames(Context context, String resourceId, ConsistencyLevel readConsistency) {
        BoundStatement bindStatement = this.m_selectMetricNamesStatement.bind();
        bindStatement.setString("context", context.getId());
        bindStatement.setString("resource", resourceId);
        bindStatement.setConsistencyLevel(readConsistency);
        return this.m_session.executeAsync((Statement)bindStatement);
    }

    private Collection<String> getMetricNamesFromResults(ResultSetFuture results) throws InterruptedException, ExecutionException {
        ArrayList metricNames = Lists.newArrayList();
        for (Row row : (ResultSet)results.get()) {
            metricNames.add(row.getString("metric_name"));
        }
        return metricNames;
    }
}

