/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;

public class CassandraCachePrimer {
    public static final int DEFAULT_FETCH_SIZE = 10000;
    public static final int DEFAULT_FETCH_MORE_THRESHOLD = 1000;
    private final CassandraSession m_session;
    private final PreparedStatement m_selectAllMetricsStatement;
    private final PreparedStatement m_selectAllAttributesStatement;
    private int m_fetchSize = 10000;
    private int m_fetchMoreThreshold = 1000;

    @Inject
    public CassandraCachePrimer(CassandraSession session) {
        this.m_session = (CassandraSession)Preconditions.checkNotNull((Object)session);
        Select select = QueryBuilder.select().column("context").column("resource").column("metric_name").from("resource_metrics");
        this.m_selectAllMetricsStatement = session.prepare(select.toString());
        select = QueryBuilder.select().column("context").column("resource").column("attribute").column("value").ttl("value").as("ttl").from("resource_attributes");
        this.m_selectAllAttributesStatement = session.prepare(select.toString());
    }

    public void prime(ResourceMetadataCache cache) {
        this.prime(cache, null);
    }

    public void prime(ResourceMetadataCache cache, Context context) {
        ResourceMetadata resourceMetadata;
        Resource resource;
        Context rowContext;
        BoundStatement bindStatement = this.m_selectAllMetricsStatement.bind();
        bindStatement.setFetchSize(this.m_fetchSize);
        ResultSet rs = this.m_session.execute((Statement)bindStatement);
        for (Row row : rs) {
            if (rs.getAvailableWithoutFetching() == this.m_fetchMoreThreshold && !rs.isFullyFetched()) {
                rs.fetchMoreResults();
            }
            rowContext = new Context(row.getString("context"));
            if (context != null && !context.equals((Object)rowContext)) continue;
            resource = new Resource(row.getString("resource"));
            resourceMetadata = new ResourceMetadata();
            resourceMetadata.setExpires(null);
            resourceMetadata.putMetric(row.getString("metric_name"));
            cache.merge(rowContext, resource, resourceMetadata);
        }
        bindStatement = this.m_selectAllAttributesStatement.bind();
        bindStatement.setFetchSize(this.m_fetchSize);
        for (Row row : this.m_session.execute((Statement)bindStatement)) {
            if (rs.getAvailableWithoutFetching() == this.m_fetchMoreThreshold && !rs.isFullyFetched()) {
                rs.fetchMoreResults();
            }
            rowContext = new Context(row.getString("context"));
            if (context != null && !context.equals((Object)rowContext)) continue;
            resource = new Resource(row.getString("resource"));
            resourceMetadata = new ResourceMetadata();
            resourceMetadata.setExpires(System.currentTimeMillis() + (long)row.getInt("ttl") * 1000L * 3L / 4L);
            resourceMetadata.putAttribute(row.getString("attribute"), row.getString("value"));
            cache.merge(rowContext, resource, resourceMetadata);
        }
    }

    public int getFetchSize() {
        return this.m_fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.m_fetchSize = fetchSize;
    }

    public int getFetchMoreThreshold() {
        return this.m_fetchMoreThreshold;
    }

    public void setFetchMoreThreshold(int fetchMoreThreshold) {
        this.m_fetchMoreThreshold = fetchMoreThreshold;
    }
}

