/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;

public class CassandraCachePrimer {
    public static final int DEFAULT_FETCH_SIZE = 10000;
    public static final int DEFAULT_FETCH_MORE_THRESHOLD = 1000;
    private final CassandraSession m_session;
    private final PreparedStatement m_selectAllMetricsStatement;
    private final PreparedStatement m_selectAllAttributesStatement;
    private int m_fetchSize = 10000;
    private int m_fetchMoreThreshold = 1000;

    @Inject
    public CassandraCachePrimer(CassandraSession session) {
        this.m_session = (CassandraSession)Preconditions.checkNotNull((Object)session);
        Select select = QueryBuilder.selectFrom((String)"resource_metrics").column("context").column("resource").column("metric_name");
        this.m_selectAllMetricsStatement = session.prepare(select.toString());
        select = QueryBuilder.selectFrom((String)"resource_attributes").column("context").column("resource").column("attribute").column("value").ttl("value").as("ttl");
        this.m_selectAllAttributesStatement = session.prepare(select.toString());
    }

    public void prime(ResourceMetadataCache cache) {
        this.prime(cache, null);
    }

    public void prime(ResourceMetadataCache cache, Context context) {
        ResourceMetadata resourceMetadata;
        Resource resource;
        Context rowContext;
        BoundStatement bindStatement = (BoundStatement)this.m_selectAllMetricsStatement.bind(new Object[0]).setPageSize(this.m_fetchSize);
        ResultSet rs = this.m_session.execute((Statement)bindStatement);
        for (Row row : rs) {
            rowContext = new Context(row.getString("context"));
            if (context != null && !context.equals((Object)rowContext)) continue;
            resource = new Resource(row.getString("resource"));
            resourceMetadata = new ResourceMetadata();
            resourceMetadata.setExpires(null);
            resourceMetadata.putMetric(row.getString("metric_name"));
            cache.merge(rowContext, resource, resourceMetadata);
        }
        bindStatement = (BoundStatement)this.m_selectAllAttributesStatement.bind(new Object[0]).setPageSize(this.m_fetchSize);
        for (Row row : this.m_session.execute((Statement)bindStatement)) {
            rowContext = new Context(row.getString("context"));
            if (context != null && !context.equals((Object)rowContext)) continue;
            resource = new Resource(row.getString("resource"));
            resourceMetadata = new ResourceMetadata();
            resourceMetadata.setExpires(System.currentTimeMillis() + (long)row.getInt("ttl") * 1000L * 3L / 4L);
            resourceMetadata.putAttribute(row.getString("attribute"), row.getString("value"));
            cache.merge(rowContext, resource, resourceMetadata);
        }
    }

    public int getFetchSize() {
        return this.m_fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.m_fetchSize = fetchSize;
    }

    public int getFetchMoreThreshold() {
        return this.m_fetchMoreThreshold;
    }

    public void setFetchMoreThreshold(int fetchMoreThreshold) {
        this.m_fetchMoreThreshold = fetchMoreThreshold;
    }
}

