/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import com.datastax.driver.core.Cluster;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.CassandraCQLUnit;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;

public class MyCassandraCQLUnit
extends CassandraCQLUnit {
    private final CQLDataSet dataSet;

    public MyCassandraCQLUnit(CQLDataSet dataSet, String configurationFileName) {
        super(dataSet, configurationFileName);
        this.dataSet = dataSet;
    }

    protected void load() {
        String hostIp = EmbeddedCassandraServerHelper.getHost();
        int port = EmbeddedCassandraServerHelper.getNativeTransportPort();
        this.cluster = new Cluster.Builder().addContactPoint(hostIp).withPort(port).build();
        this.session = this.cluster.connect();
        CQLDataLoader dataLoader = new CQLDataLoader(this.session);
        dataLoader.load(this.dataSet);
        this.session = dataLoader.getSession();
    }

    public void before() throws Exception {
        super.before();
    }
}

