/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.cassandraunit.MyCassandraCQLUnit;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.cql.FileCQLDataSet;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraTestCase {
    protected static final String CASSANDRA_CONFIG = "cassandra.yaml";
    protected static final String CASSANDRA_HOST = "localhost";
    protected static final int CASSANDRA_PORT = 9043;
    protected static final String CASSANDRA_COMPRESSION = "NONE";
    protected static final String CASSANDRA_KEYSPACE = "newts";
    public static final String CASSANDRA_USERNAME = "cassandra";
    public static final String CASSANDRA_PASSWORD = "cassandra";
    protected static final String KEYSPACE_PLACEHOLDER = "$KEYSPACE$";
    private static final Logger log = LoggerFactory.getLogger(AbstractCassandraTestCase.class);
    private MyCassandraCQLUnit cassandraUnit = new MyCassandraCQLUnit(this.getDataSet(), "cassandra.yaml");
    private boolean initialized = false;
    private Session session;
    private Cluster cluster;

    @Before
    public void setUp() throws Exception {
        if (!this.initialized) {
            this.cassandraUnit.before();
            this.session = this.cassandraUnit.session;
            this.cluster = this.cassandraUnit.cluster;
            this.initialized = true;
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.session != null) {
            log.debug("session shutdown");
            CloseFuture closeFuture = this.session.closeAsync();
            closeFuture.force();
        }
        if (this.cluster != null) {
            log.debug("cluster shutdown");
            this.cluster.close();
        }
    }

    protected abstract String getSchemaResource();

    public CQLDataSet getDataSet() {
        try {
            String schema = Resources.toString((URL)this.getClass().getResource(this.getSchemaResource()), (Charset)Charsets.UTF_8);
            schema = schema.replace(KEYSPACE_PLACEHOLDER, CASSANDRA_KEYSPACE);
            File schemaFile = File.createTempFile("schema-", ".cql", new File("target"));
            Files.write((CharSequence)schema, (File)schemaFile, (Charset)Charsets.UTF_8);
            return new FileCQLDataSet(schemaFile.getAbsolutePath(), false, true, CASSANDRA_KEYSPACE);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

