/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ServiceLoader;
import org.cassandraunit.MyCassandraCQLUnit;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.cql.FileCQLDataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.junit.rules.ExternalResource;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.CassandraSessionImpl;
import org.opennms.newts.cassandra.Schema;

public class NewtsInstance
extends ExternalResource {
    private static final String CASSANDRA_COMPRESSION = "NONE";
    private static final String CASSANDRA_KEYSPACE = "newts";
    private static final String CASSANDRA_USERNAME = "cassandra";
    private static final String CASSANDRA_PASSWORD = "cassandra";
    private static final String KEYSPACE_PLACEHOLDER = "$KEYSPACE$";
    private static final String REPLICATION_FACTOR_PLACEHOLDER = "$REPLICATION_FACTOR$";
    private static ServiceLoader<Schema> schemaLoader = ServiceLoader.load(Schema.class);
    private MyCassandraCQLUnit cassandraUnit;
    private String host;
    private int port;

    public void before() throws Throwable {
        this.cassandraUnit = new MyCassandraCQLUnit(NewtsInstance.getDataSet(CASSANDRA_KEYSPACE, 1));
        this.cassandraUnit.before();
        this.host = EmbeddedCassandraServerHelper.getHost();
        this.port = EmbeddedCassandraServerHelper.getNativeTransportPort();
    }

    public void after() {
        this.cassandraUnit.after();
    }

    public CassandraSession getCassandraSession() {
        return new CassandraSessionImpl(CASSANDRA_KEYSPACE, this.host, this.port, CASSANDRA_COMPRESSION, "cassandra", "cassandra", false);
    }

    public static CQLDataSet getDataSet(String keyspace, int replicationFactor) {
        try {
            String schemasString = "";
            for (Schema schema : schemaLoader) {
                schemasString = schemasString + CharStreams.toString((Readable)new InputStreamReader(schema.getInputStream()));
            }
            schemasString = schemasString.replace(KEYSPACE_PLACEHOLDER, keyspace);
            schemasString = schemasString.replace(REPLICATION_FACTOR_PLACEHOLDER, Integer.toString(replicationFactor));
            String[] lines = schemasString.split("\\r?\\n");
            StringBuffer sb = new StringBuffer();
            boolean foundCreateKeyspace = false;
            boolean skipNextLine = false;
            for (String line : lines) {
                if (line.startsWith("CREATE KEYSPACE")) {
                    if (!foundCreateKeyspace) {
                        foundCreateKeyspace = true;
                        sb.append(line);
                        sb.append("\n");
                        continue;
                    }
                    skipNextLine = true;
                    continue;
                }
                if (skipNextLine) {
                    skipNextLine = false;
                    continue;
                }
                sb.append(line);
                sb.append("\n");
            }
            File schemaFile = File.createTempFile("schema-", ".cql", new File("target"));
            schemaFile.deleteOnExit();
            Files.write((CharSequence)sb.toString(), (File)schemaFile, (Charset)Charsets.UTF_8);
            return new FileCQLDataSet(schemaFile.getAbsolutePath(), false, true, keyspace);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getCompression() {
        return CASSANDRA_COMPRESSION;
    }

    public String getKeyspace() {
        return CASSANDRA_KEYSPACE;
    }

    public String getUsername() {
        return "cassandra";
    }

    public String getPassword() {
        return "cassandra";
    }
}

